/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToLongFunction;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public final class SizeOf {
    public static final byte SIZE_OF_BYTE = 1;
    public static final byte SIZE_OF_SHORT = 2;
    public static final byte SIZE_OF_INT = 4;
    public static final byte SIZE_OF_LONG = 8;
    public static final byte SIZE_OF_FLOAT = 4;
    public static final byte SIZE_OF_DOUBLE = 8;
    private static final int SIMPLE_ENTRY_INSTANCE_SIZE = ClassLayout.parseClass(AbstractMap.SimpleEntry.class).instanceSize();
    private static final int STRING_INSTANCE_SIZE = ClassLayout.parseClass(String.class).instanceSize();

    public static long sizeOf(boolean[] array) {
        return array == null ? 0L : SizeOf.sizeOfBooleanArray(array.length);
    }

    public static long sizeOf(byte[] array) {
        return array == null ? 0L : SizeOf.sizeOfByteArray(array.length);
    }

    public static long sizeOf(short[] array) {
        return array == null ? 0L : SizeOf.sizeOfShortArray(array.length);
    }

    public static long sizeOf(char[] array) {
        return array == null ? 0L : SizeOf.sizeOfCharArray(array.length);
    }

    public static long sizeOf(int[] array) {
        return array == null ? 0L : SizeOf.sizeOfIntArray(array.length);
    }

    public static long sizeOf(long[] array) {
        return array == null ? 0L : SizeOf.sizeOfLongArray(array.length);
    }

    public static long sizeOf(float[] array) {
        return array == null ? 0L : SizeOf.sizeOfFloatArray(array.length);
    }

    public static long sizeOf(double[] array) {
        return array == null ? 0L : SizeOf.sizeOfDoubleArray(array.length);
    }

    public static long sizeOf(Object[] array) {
        return array == null ? 0L : SizeOf.sizeOfObjectArray(array.length);
    }

    public static long estimatedSizeOf(String string) {
        return string == null ? 0L : (long)(STRING_INSTANCE_SIZE + string.length() * 2);
    }

    public static <T> long estimatedSizeOf(List<T> list, ToLongFunction<T> valueSize) {
        if (list == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(list.size());
        for (T value : list) {
            result += valueSize.applyAsLong(value);
        }
        return result;
    }

    public static <K, V> long estimatedSizeOf(Map<K, V> map, ToLongFunction<K> keySize, ToLongFunction<V> valueSize) {
        if (map == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result += (long)SIMPLE_ENTRY_INSTANCE_SIZE + keySize.applyAsLong(entry.getKey()) + valueSize.applyAsLong(entry.getValue());
        }
        return result;
    }

    public static long sizeOfBooleanArray(int length) {
        return (long)Unsafe.ARRAY_BOOLEAN_BASE_OFFSET + (long)Unsafe.ARRAY_BOOLEAN_INDEX_SCALE * (long)length;
    }

    public static long sizeOfByteArray(int length) {
        return (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)Unsafe.ARRAY_BYTE_INDEX_SCALE * (long)length;
    }

    public static long sizeOfShortArray(int length) {
        return (long)Unsafe.ARRAY_SHORT_BASE_OFFSET + (long)Unsafe.ARRAY_SHORT_INDEX_SCALE * (long)length;
    }

    public static long sizeOfCharArray(int length) {
        return (long)Unsafe.ARRAY_CHAR_BASE_OFFSET + (long)Unsafe.ARRAY_CHAR_INDEX_SCALE * (long)length;
    }

    public static long sizeOfIntArray(int length) {
        return (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)Unsafe.ARRAY_INT_INDEX_SCALE * (long)length;
    }

    public static long sizeOfLongArray(int length) {
        return (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)Unsafe.ARRAY_LONG_INDEX_SCALE * (long)length;
    }

    public static long sizeOfFloatArray(int length) {
        return (long)Unsafe.ARRAY_FLOAT_BASE_OFFSET + (long)Unsafe.ARRAY_FLOAT_INDEX_SCALE * (long)length;
    }

    public static long sizeOfDoubleArray(int length) {
        return (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE * (long)length;
    }

    public static long sizeOfObjectArray(int length) {
        return (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE * (long)length;
    }

    private SizeOf() {
    }
}

