/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationFactory;

@Beta
public interface ConfigurationAwareModule
extends Module {
    public void setConfigurationFactory(ConfigurationFactory var1);

    public static Module combine(Module ... modules) {
        return ConfigurationAwareModule.combine(ImmutableList.copyOf(modules));
    }

    public static Module combine(Iterable<Module> modulesIterable) {
        final ImmutableList<Module> modules = ImmutableList.copyOf(modulesIterable);
        Preconditions.checkArgument(!modules.isEmpty(), "no modules provided");
        if (modules.size() == 1) {
            return (Module)modules.get(0);
        }
        return new AbstractConfigurationAwareModule(){

            @Override
            protected void setup(Binder binder) {
                for (Module module : modules) {
                    this.install(module);
                }
            }
        };
    }
}

