/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.heap;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.util.Multiset;

public class HeapDumpReader {
    private final InputStream is;
    private final Map<Long, String> strings;
    private final Map<Long, String> classNames;
    private final Multiset<ClassData> classCounts;
    private final Map<Long, ClassData> classDatas;
    private int idSize;
    private int readBytes;
    private final byte[] buf;
    private final ByteBuffer wrapBuf;

    public HeapDumpReader(File file) throws FileNotFoundException {
        this.is = new BufferedInputStream(new FileInputStream(file));
        this.strings = new HashMap<Long, String>();
        this.classNames = new HashMap<Long, String>();
        this.classCounts = new Multiset();
        this.classDatas = new HashMap<Long, ClassData>();
        this.buf = new byte[4096];
        this.wrapBuf = ByteBuffer.wrap(this.buf);
    }

    private int read() throws IOException {
        int v = this.is.read();
        if (v != -1) {
            ++this.readBytes;
            return v;
        }
        throw new EOFException();
    }

    private int read(byte[] b, int size) throws IOException {
        int read = this.is.read(b, 0, size);
        this.readBytes += read;
        return read;
    }

    public Multiset<ClassData> parse() throws IOException {
        this.readNullTerminated();
        this.idSize = this.read_U4();
        this.read_U4();
        this.read_U4();
        while (this.is.available() != 0) {
            int tag = this.read_U1();
            this.read_U4();
            int len = this.read_U4();
            int lastCount = this.readBytes;
            switch (tag) {
                case 1: {
                    long id = this.read_ID();
                    String s2 = this.readString(len - this.idSize);
                    this.strings.put(id, s2);
                    break;
                }
                case 2: {
                    this.read_U4();
                    long id = this.read_ID();
                    this.read_U4();
                    long nameID = this.read_ID();
                    this.classNames.put(id, this.strings.get(nameID));
                    break;
                }
                case 12: 
                case 28: {
                    while (this.readBytes - lastCount < len) {
                        this.digestHeapDump();
                    }
                    break;
                }
                default: {
                    this.read_null(len);
                }
            }
            if (this.readBytes - lastCount == len) continue;
            throw new IllegalStateException("Expected to read " + len + " bytes, but read " + (this.readBytes - lastCount) + " bytes");
        }
        return this.classCounts;
    }

    private void digestHeapDump() throws IOException {
        int subTag = this.read_U1();
        switch (subTag) {
            case 1: {
                this.read_ID();
                this.read_ID();
                return;
            }
            case 2: {
                this.read_ID();
                this.read_U4();
                this.read_U4();
                return;
            }
            case 3: {
                this.read_ID();
                this.read_U4();
                this.read_U4();
                return;
            }
            case 4: {
                this.read_ID();
                this.read_U4();
                return;
            }
            case 5: {
                this.read_ID();
                return;
            }
            case 6: {
                this.read_ID();
                this.read_U4();
                return;
            }
            case 7: {
                this.read_ID();
                return;
            }
            case 8: {
                this.read_ID();
                this.read_U4();
                this.read_U4();
                return;
            }
            case 32: {
                this.digestClass();
                return;
            }
            case 33: {
                this.digestInstance();
                return;
            }
            case 34: {
                this.digestObjArray();
                return;
            }
            case 35: {
                this.digestPrimArray();
                return;
            }
        }
        throw new IllegalStateException("Unknown subtag: " + subTag);
    }

    private void digestPrimArray() throws IOException {
        this.read_ID();
        this.read_U4();
        int elements = this.read_U4();
        int typeClass = this.read_U1();
        this.read_null(elements * this.getSize(typeClass));
        this.classCounts.add(new ClassData(this.getTypeString(typeClass) + "[]", this.getTypeString(typeClass), elements));
    }

    private void digestObjArray() throws IOException {
        this.read_ID();
        this.read_U4();
        int elements = this.read_U4();
        this.read_ID();
        this.read_null(elements * this.idSize);
        this.classCounts.add(new ClassData("Object[]", "Object", elements));
    }

    private void digestInstance() throws IOException {
        this.read_ID();
        this.read_U4();
        long klassID = this.read_ID();
        this.classCounts.add(this.classDatas.get(klassID));
        int instanceBytes = this.read_U4();
        this.read_null(instanceBytes);
    }

    private void digestClass() throws IOException {
        long klassID = this.read_ID();
        String name = this.classNames.get(klassID);
        ClassData cd2 = new ClassData(name);
        cd2.addSuperClass(name);
        this.read_U4();
        long superKlassID = this.read_ID();
        ClassData superCd = this.classDatas.get(superKlassID);
        if (superCd != null) {
            cd2.merge(superCd);
        }
        this.read_ID();
        this.read_ID();
        this.read_ID();
        this.read_ID();
        this.read_ID();
        this.read_U4();
        int cpCount = this.read_U2();
        for (int c = 0; c < cpCount; ++c) {
            this.read_U2();
            int type = this.read_U1();
            this.readValue(type);
        }
        int cpStatics = this.read_U2();
        for (int c = 0; c < cpStatics; ++c) {
            this.read_ID();
            int type = this.read_U1();
            this.readValue(type);
        }
        int cpInstance = this.read_U2();
        for (int c = 0; c < cpInstance; ++c) {
            long index = this.read_ID();
            int type = this.read_U1();
            cd2.addField(FieldData.create(name, this.strings.get(index), this.getTypeString(type)));
        }
        this.classDatas.put(klassID, cd2);
    }

    private long readValue(int type) throws IOException {
        int size = this.getSize(type);
        switch (size) {
            case 1: {
                return this.read_U1();
            }
            case 2: {
                return this.read_U2();
            }
            case 4: {
                return this.read_U4();
            }
            case 8: {
                return this.read_U8();
            }
        }
        throw new IllegalStateException("Unknown size: " + size);
    }

    private int getSize(int type) throws IOException {
        switch (type) {
            case 2: {
                if (this.idSize == 4) {
                    return 4;
                }
                if (this.idSize == 8) {
                    return 8;
                }
                throw new IllegalStateException();
            }
            case 4: 
            case 8: {
                return 1;
            }
            case 5: 
            case 9: {
                return 2;
            }
            case 6: 
            case 10: {
                return 4;
            }
            case 7: 
            case 11: {
                return 8;
            }
        }
        throw new IllegalStateException("Unknown type: " + type);
    }

    private String getTypeString(int type) throws IOException {
        switch (type) {
            case 2: {
                return "Object";
            }
            case 4: {
                return "boolean";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 5: {
                return "char";
            }
            case 10: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 11: {
                return "long";
            }
        }
        throw new IllegalStateException("Unknown type: " + type);
    }

    private long read_ID() throws IOException {
        int read = this.read(this.buf, this.idSize);
        if (read == this.idSize) {
            if (this.idSize <= 4) {
                return this.wrapBuf.get(0);
            }
            return this.wrapBuf.getLong(0);
        }
        throw new IllegalStateException("Unable to read 1 bytes");
    }

    void read_null(int len) throws IOException {
        int read;
        int rem = len;
        while ((rem -= (read = this.read(this.buf, Math.min(this.buf.length, rem)))) > 0) {
        }
    }

    String readNullTerminated() throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        while ((r = this.read()) != -1 && r != 0) {
            sb.append((char)(r & 0xFF));
        }
        return sb.toString();
    }

    String readString(int len) throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        for (int l = 0; l < len && (r = this.read()) != -1; ++l) {
            sb.append((char)(r & 0xFF));
        }
        return sb.toString();
    }

    long read_U8() throws IOException {
        int read = this.read(this.buf, 8);
        if (read == 8) {
            return this.wrapBuf.getLong(0);
        }
        throw new IllegalStateException("Unable to read 8 bytes");
    }

    int read_U4() throws IOException {
        int read = this.read(this.buf, 4);
        if (read == 4) {
            return this.wrapBuf.getInt(0);
        }
        throw new IllegalStateException("Unable to read 4 bytes");
    }

    int read_U2() throws IOException {
        int read = this.read(this.buf, 2);
        if (read == 2) {
            return this.wrapBuf.getShort(0);
        }
        throw new IllegalStateException("Unable to read 2 bytes");
    }

    int read_U1() throws IOException {
        int read = this.read(this.buf, 1);
        if (read == 1) {
            return this.wrapBuf.get(0);
        }
        throw new IllegalStateException("Unable to read 1 bytes");
    }
}

