/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.validation.ElementKind;
import javax.validation.ParameterNameProvider;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.groups.GroupConversion;
import org.apache.bval.jsr.metadata.AnnotationBehavior;
import org.apache.bval.jsr.metadata.AnnotationBehaviorMergeStrategy;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.metadata.EmptyBuilder;
import org.apache.bval.jsr.metadata.HasAnnotationBehavior;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;

public class CompositeBuilder {
    private final AnnotationBehaviorMergeStrategy annotationBehaviorStrategy;
    protected final ApacheValidatorFactory validatorFactory;

    public static CompositeBuilder with(ApacheValidatorFactory validatorFactory, AnnotationBehaviorMergeStrategy annotationBehaviorStrategy) {
        return new CompositeBuilder(validatorFactory, annotationBehaviorStrategy);
    }

    protected CompositeBuilder(ApacheValidatorFactory validatorFactory, AnnotationBehaviorMergeStrategy annotationBehaviorMergeStrategy) {
        this.annotationBehaviorStrategy = Validate.notNull(annotationBehaviorMergeStrategy, "annotationBehaviorMergeStrategy", new Object[0]);
        this.validatorFactory = Validate.notNull(validatorFactory, "validatorFactory", new Object[0]);
    }

    public <T> Collector<MetadataBuilder.ForBean<T>, ?, MetadataBuilder.ForBean<T>> compose() {
        return Collectors.collectingAndThen(Collectors.toList(), delegates -> delegates.isEmpty() ? EmptyBuilder.instance().forBean() : (delegates.size() == 1 ? (MetadataBuilder.ForBean)delegates.get(0) : new ForBean(delegates)));
    }

    public <E extends AnnotatedElement> Collector<MetadataBuilder.ForContainer<E>, ?, MetadataBuilder.ForContainer<E>> composeContainer() {
        return Collectors.collectingAndThen(Collectors.toList(), delegates -> delegates.isEmpty() ? EmptyBuilder.instance().forContainer() : (delegates.size() == 1 ? (MetadataBuilder.ForContainer)delegates.get(0) : new ForContainer(delegates)));
    }

    protected final <E extends Executable> List<Meta<Parameter>> getMetaParameters(Meta<E> meta, BiFunction<ParameterNameProvider, E, List<String>> getParameterNames) {
        Parameter[] parameters = ((Executable)meta.getHost()).getParameters();
        List<String> parameterNames = getParameterNames.apply(this.validatorFactory.getParameterNameProvider(), meta.getHost());
        if (parameterNames.size() != parameters.length) {
            Exceptions.raise(IllegalStateException::new, "%s returned wrong number of parameter names", this.validatorFactory.getParameterNameProvider());
        }
        return IntStream.range(0, parameters.length).mapToObj(n -> new Meta.ForParameter(parameters[n], (String)parameterNames.get(n))).collect(Collectors.toList());
    }

    protected <E extends AnnotatedElement> Map<Meta<E>, Annotation[]> getConstraintDeclarationMap(ForElement<? extends MetadataBuilder.ForElement<E>, E> composite, Meta<E> meta) {
        return Collections.singletonMap(meta, composite.getDeclaredConstraints(meta));
    }

    protected <T> List<Class<?>> getGroupSequence(ForClass<T> composite, Meta<Class<T>> meta) {
        List groupSequence = composite.delegates.stream().map(d -> d.getGroupSequence(meta)).collect(Collectors.toList());
        Validate.validState(groupSequence.size() <= 1, "group sequence returned from multiple composite class metadata builders", new Object[0]);
        return groupSequence.isEmpty() ? null : (List)groupSequence.get(0);
    }

    protected <DELEGATE extends MetadataBuilder.ForContainer<E>, E extends AnnotatedElement> MetadataBuilder.ForContainer<E> forContainer(List<DELEGATE> delegates, Meta<E> meta, ElementKind elementKind) {
        return new ForContainer(delegates);
    }

    protected <DELEGATE extends MetadataBuilder.ForElement<E>, E extends Executable> MetadataBuilder.ForElement<E> forCrossParameter(List<DELEGATE> delegates, Meta<E> meta) {
        return new ForElement(delegates);
    }

    class ForExecutable<DELEGATE extends MetadataBuilder.ForExecutable<E>, E extends Executable>
    extends Delegator<DELEGATE>
    implements MetadataBuilder.ForExecutable<E> {
        private final BiFunction<ParameterNameProvider, E, List<String>> getParameterNames;

        ForExecutable(List<DELEGATE> delegates, BiFunction<ParameterNameProvider, E, List<String>> getParameterNames) {
            super(delegates);
            this.getParameterNames = Validate.notNull(getParameterNames, "getParameterNames", new Object[0]);
        }

        @Override
        public MetadataBuilder.ForContainer<E> getReturnValue(Meta<E> meta) {
            return CompositeBuilder.this.forContainer(this.delegates.stream().map(d -> d.getReturnValue(meta)).collect(Collectors.toList()), meta, ElementKind.RETURN_VALUE);
        }

        @Override
        public List<MetadataBuilder.ForContainer<Parameter>> getParameters(Meta<E> meta) {
            List parameterLists = this.delegates.stream().map(d -> d.getParameters(meta)).collect(Collectors.toList());
            Set parameterCounts = parameterLists.stream().map(List::size).collect(Collectors.toSet());
            Validate.validState(parameterCounts.size() == 1, "Mismatched parameter counts: %s", parameterCounts);
            int parameterCount = (Integer)parameterCounts.iterator().next();
            List<Meta<Parameter>> metaParams = CompositeBuilder.this.getMetaParameters(meta, this.getParameterNames);
            return IntStream.range(0, parameterCount).mapToObj(n -> CompositeBuilder.this.forContainer(parameterLists.stream().map(l -> (MetadataBuilder.ForContainer)l.get(n)).collect(Collectors.toList()), (Meta)metaParams.get(n), ElementKind.PARAMETER)).collect(ToUnmodifiable.list());
        }

        @Override
        public MetadataBuilder.ForElement<E> getCrossParameter(Meta<E> meta) {
            return CompositeBuilder.this.forCrossParameter(this.delegates.stream().map(d -> d.getCrossParameter(meta)).collect(Collectors.toList()), meta);
        }
    }

    class ForContainer<DELEGATE extends MetadataBuilder.ForContainer<E>, E extends AnnotatedElement>
    extends ForElement<DELEGATE, E>
    implements MetadataBuilder.ForContainer<E> {
        ForContainer(List<DELEGATE> delegates) {
            super(delegates);
        }

        @Override
        public boolean isCascade(Meta<E> meta) {
            return this.delegates.stream().anyMatch(d -> d.isCascade(meta));
        }

        @Override
        public Set<GroupConversion> getGroupConversions(Meta<E> meta) {
            return this.delegates.stream().map(d -> d.getGroupConversions(meta)).flatMap(Collection::stream).collect(ToUnmodifiable.set());
        }

        @Override
        public Map<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> getContainerElementTypes(Meta<E> meta) {
            return this.merge((DELEGATE b) -> b.getContainerElementTypes(meta), (K k, List<D> l) -> CompositeBuilder.this.forContainer(l, new Meta.ForContainerElement(meta, (ContainerElementKey)k), ElementKind.CONTAINER_ELEMENT));
        }
    }

    class ForClass<T>
    extends ForElement<MetadataBuilder.ForClass<T>, Class<T>>
    implements MetadataBuilder.ForClass<T> {
        ForClass(List<MetadataBuilder.ForClass<T>> delegates) {
            super(delegates);
        }

        @Override
        public List<Class<?>> getGroupSequence(Meta<Class<T>> meta) {
            return CompositeBuilder.this.getGroupSequence(this, meta);
        }
    }

    class ForElement<DELEGATE extends MetadataBuilder.ForElement<E>, E extends AnnotatedElement>
    extends Delegator<DELEGATE>
    implements MetadataBuilder.ForElement<E> {
        ForElement(List<DELEGATE> delegates) {
            super(delegates);
        }

        @Override
        public Map<Meta<E>, Annotation[]> getConstraintDeclarationMap(Meta<E> meta) {
            return CompositeBuilder.this.getConstraintDeclarationMap(this, meta);
        }

        @Override
        public final Annotation[] getDeclaredConstraints(Meta<E> meta) {
            return (Annotation[])this.delegates.stream().map(d -> d.getDeclaredConstraints(meta)).flatMap(Stream::of).toArray(Annotation[]::new);
        }
    }

    class ForBean<T>
    extends Delegator<MetadataBuilder.ForBean<T>>
    implements MetadataBuilder.ForBean<T> {
        ForBean(List<MetadataBuilder.ForBean<T>> delegates) {
            super(delegates);
        }

        @Override
        public MetadataBuilder.ForClass<T> getClass(Meta<Class<T>> meta) {
            return new ForClass(this.delegates.stream().map(d -> d.getClass(meta)).collect(Collectors.toList()));
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Field>> getFields(Meta<Class<T>> meta) {
            return this.merge((DELEGATE b) -> b.getFields(meta), (K f, List<D> l) -> {
                Field fld = Reflection.find((Class)meta.getHost(), t -> Reflection.getDeclaredField(t, f));
                if (fld == null) {
                    Exceptions.raise(IllegalStateException::new, "Could not find field %s of %s", f, meta.getHost());
                }
                return CompositeBuilder.this.forContainer(l, new Meta.ForField(fld), ElementKind.PROPERTY);
            });
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Method>> getGetters(Meta<Class<T>> meta) {
            return this.merge((DELEGATE b) -> b.getGetters(meta), (K g2, List<D> l) -> {
                Method getter = Methods.getter((Class)meta.getHost(), g2);
                if (getter == null) {
                    Exceptions.raise(IllegalStateException::new, "Could not find getter for property %s of %s", g2, meta.getHost());
                }
                return CompositeBuilder.this.forContainer(l, new Meta.ForMethod(getter), ElementKind.PROPERTY);
            });
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Constructor<? extends T>>> getConstructors(Meta<Class<T>> meta) {
            return this.merge((DELEGATE b) -> b.getConstructors(meta), (List<D> d) -> new ForExecutable(d, ParameterNameProvider::getParameterNames));
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Method>> getMethods(Meta<Class<T>> meta) {
            return this.merge((DELEGATE b) -> b.getMethods(meta), (List<D> d) -> new ForExecutable(d, ParameterNameProvider::getParameterNames));
        }
    }

    class Delegator<DELEGATE extends HasAnnotationBehavior>
    implements HasAnnotationBehavior {
        protected final List<DELEGATE> delegates;

        Delegator(List<DELEGATE> delegates) {
            this.delegates = Validate.notNull(delegates, "delegates", new Object[0]);
            Validate.isTrue(!delegates.isEmpty(), "no delegates specified", new Object[0]);
            Validate.isTrue(delegates.stream().noneMatch(Objects::isNull), "One or more supplied delegates was null", new Object[0]);
        }

        @Override
        public AnnotationBehavior getAnnotationBehavior() {
            return (AnnotationBehavior)CompositeBuilder.this.annotationBehaviorStrategy.apply(this.delegates);
        }

        <K, D> Map<K, D> merge(Function<DELEGATE, Map<K, D>> toMap, Function<List<D>, D> merge) {
            return this.merge(toMap, (K k, List<D> l) -> merge.apply((List)l));
        }

        <K, D> Map<K, D> merge(Function<DELEGATE, Map<K, D>> toMap, BiFunction<K, List<D>, D> merge) {
            List maps = this.delegates.stream().map(toMap).filter(m3 -> !m3.isEmpty()).collect(Collectors.toList());
            Function<Object, Object> valueMapper = k -> {
                List mappedDelegates = maps.stream().map(m3 -> m3.get(k)).filter(Objects::nonNull).collect(Collectors.toList());
                return mappedDelegates.size() == 1 ? mappedDelegates.get(0) : merge.apply(k, mappedDelegates);
            };
            return maps.stream().map(Map::keySet).flatMap(Collection::stream).distinct().collect(Collectors.toMap(Function.identity(), valueMapper));
        }
    }
}

