/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Validate;

public interface GroupStrategy {
    public static final GroupStrategy EMPTY = new GroupStrategy(){

        @Override
        public GroupStrategy redefining(Map<Group, ? extends GroupStrategy> redefinitions) {
            return this;
        }

        @Override
        public Set<Group> getGroups() {
            return Collections.emptySet();
        }
    };

    public static GroupStrategy redefining(GroupStrategy source, Map<Group, ? extends GroupStrategy> redefinitions) {
        Validate.notNull(source, "source", new Object[0]);
        if (redefinitions != null && !redefinitions.isEmpty()) {
            if (redefinitions.containsValue(null)) {
                redefinitions = redefinitions.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            if (!redefinitions.isEmpty()) {
                return source.redefining(redefinitions);
            }
        }
        return source;
    }

    public static GroupStrategy simple(Group ... groups) {
        return GroupStrategy.simple(Arrays.asList(groups));
    }

    public static GroupStrategy simple(Collection<? extends Group> coll) {
        Validate.notNull(coll);
        if (coll.size() == 1) {
            return coll.iterator().next();
        }
        Set<? extends Group> groups = Collections.unmodifiableSet(new LinkedHashSet<Group>(coll));
        return new Simple(groups);
    }

    public static GroupStrategy composite(GroupStrategy ... components) {
        return GroupStrategy.composite(Arrays.asList(components));
    }

    public static GroupStrategy composite(Collection<? extends GroupStrategy> components) {
        if (components.isEmpty()) {
            return EMPTY;
        }
        if (components.size() == 1) {
            return components.iterator().next();
        }
        LinkedHashSet<GroupStrategy> compressedComponents = new LinkedHashSet<GroupStrategy>();
        Consumer<Set> addGroups = s2 -> {
            if (!s2.isEmpty()) {
                compressedComponents.add(GroupStrategy.simple(s2));
                s2.clear();
            }
        };
        HashSet<Group> unorderedGroups = new HashSet<Group>();
        for (GroupStrategy groupStrategy : components) {
            if (groupStrategy instanceof Composite && ((Composite)groupStrategy).ordered) {
                addGroups.accept(unorderedGroups);
                compressedComponents.add(groupStrategy);
                continue;
            }
            unorderedGroups.addAll(groupStrategy.getGroups());
        }
        addGroups.accept(unorderedGroups);
        if (compressedComponents.size() == 1) {
            return (GroupStrategy)compressedComponents.iterator().next();
        }
        return new Composite(compressedComponents, false);
    }

    public Set<Group> getGroups();

    public GroupStrategy redefining(Map<Group, ? extends GroupStrategy> var1);

    default public boolean applyTo(Predicate<GroupStrategy> operation) {
        return operation.test(this);
    }

    public static class Composite
    implements GroupStrategy {
        private final Set<? extends GroupStrategy> components;
        protected final boolean ordered;

        public Composite(Collection<? extends GroupStrategy> components, boolean ordered) {
            Validate.isTrue(Validate.notNull(components).stream().noneMatch(Objects::isNull), "null component not permitted", new Object[0]);
            this.components = new LinkedHashSet<GroupStrategy>(components);
            this.ordered = ordered;
        }

        @Override
        public Set<Group> getGroups() {
            return this.components.stream().map(GroupStrategy::getGroups).flatMap(Collection::stream).collect(ToUnmodifiable.set());
        }

        @Override
        public GroupStrategy redefining(Map<Group, ? extends GroupStrategy> redefinitions) {
            Set redef;
            if (!this.components.isEmpty() && !(redef = this.components.stream().map(cmp -> cmp.redefining(redefinitions)).collect(Collectors.toSet())).equals(this.components)) {
                return new Composite(redef, this.ordered);
            }
            return this;
        }

        @Override
        public boolean applyTo(Predicate<GroupStrategy> operation) {
            if (this.components.isEmpty()) {
                return true;
            }
            boolean applyAll = !this.ordered;
            boolean result = true;
            for (GroupStrategy groupStrategy : this.components) {
                boolean bl = result = groupStrategy.applyTo(operation) && result;
                if (applyAll || result) continue;
                return false;
            }
            return result;
        }

        public int hashCode() {
            return Objects.hash(this.components, this.ordered);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            Composite other = (Composite)obj;
            return other.components.equals(this.components) && other.ordered == this.ordered;
        }

        public String toString() {
            return String.format("%sordered: %s", this.ordered ? "" : "un", this.components);
        }
    }

    public static class Simple
    implements GroupStrategy {
        private final Set<Group> groups;

        private Simple(Set<Group> groups) {
            this.groups = groups;
        }

        @Override
        public Set<Group> getGroups() {
            return this.groups;
        }

        @Override
        public GroupStrategy redefining(Map<Group, ? extends GroupStrategy> redefinitions) {
            if (Collections.disjoint(redefinitions.keySet(), this.groups)) {
                return this;
            }
            return this.groups.stream().map(g2 -> redefinitions.containsKey(g2) ? (GroupStrategy)redefinitions.get(g2) : g2).collect(Collectors.collectingAndThen(Collectors.toList(), GroupStrategy::composite));
        }

        public int hashCode() {
            return this.groups.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(this.getClass()) && ((Simple)obj).groups.equals(this.groups);
        }

        public String toString() {
            return this.groups.toString();
        }
    }
}

