/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.groups;

import java.util.Objects;
import java.util.Optional;
import javax.validation.metadata.GroupConversionDescriptor;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.LazyInt;
import org.apache.bval.util.Validate;

public class GroupConversion
implements GroupConversionDescriptor {
    private final Class<?> from;
    private final Class<?> to;
    private final LazyInt hashCode;
    private final Lazy<String> toString;

    public static Builder from(Class<?> from) {
        return new Builder(from);
    }

    private GroupConversion(Class<?> from, Class<?> to) {
        this.from = Validate.notNull(from, "from", new Object[0]);
        this.to = Validate.notNull(to, "to", new Object[0]);
        this.hashCode = new LazyInt(() -> Objects.hash(this.from, this.to));
        this.toString = new Lazy<String>(() -> String.format("%s from %s to %s", GroupConversion.class.getSimpleName(), this.from, this.to));
    }

    @Override
    public Class<?> getFrom() {
        return this.from;
    }

    @Override
    public Class<?> getTo() {
        return this.to;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!Optional.ofNullable(obj).filter(GroupConversion.class::isInstance).map(GroupConversion.class::cast).filter(gc -> Objects.equals(this.from, gc.from) && Objects.equals(this.to, gc.to)).isPresent()) return false;
        return true;
    }

    public int hashCode() {
        return this.hashCode.getAsInt();
    }

    public String toString() {
        return this.toString.get();
    }

    public static class Builder {
        private final Class<?> from;

        private Builder(Class<?> from) {
            this.from = from;
        }

        public GroupConversion to(Class<?> to) {
            return new GroupConversion(this.from, to);
        }
    }
}

