/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import java.lang.annotation.Annotation;
import java.time.Clock;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.IntPredicate;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public abstract class TimeValidator<A extends Annotation, T>
implements ConstraintValidator<A, T> {
    protected static final Comparator<ChronoLocalDate> CHRONO_LOCAL_DATE_COMPARATOR = Comparator.nullsFirst((quid, quo) -> quid.isBefore((ChronoLocalDate)quo) ? -1 : (quid.isAfter((ChronoLocalDate)quo) ? 1 : 0));
    protected static final Comparator<ChronoLocalDateTime<?>> CHRONO_LOCAL_DATE_TIME_COMPARATOR = Comparator.nullsFirst((quid, quo) -> quid.isBefore((ChronoLocalDateTime<?>)quo) ? -1 : (quid.isAfter((ChronoLocalDateTime<?>)quo) ? 1 : 0));
    protected static final Comparator<ChronoZonedDateTime<?>> CHRONO_ZONED_DATE_TIME_COMPARATOR = Comparator.nullsFirst((quid, quo) -> quid.isBefore((ChronoZonedDateTime<?>)quo) ? -1 : (quid.isAfter((ChronoZonedDateTime<?>)quo) ? 1 : 0));
    private final Function<Clock, T> now;
    private final Comparator<? super T> cmp;
    private final IntPredicate test;

    protected TimeValidator(Function<Clock, T> now, IntPredicate test) {
        this(now, Comparator.naturalOrder(), test);
    }

    protected TimeValidator(Function<Clock, T> now, Comparator<? super T> cmp, IntPredicate test) {
        this.now = now;
        this.cmp = cmp;
        this.test = test;
    }

    @Override
    public final boolean isValid(T value, ConstraintValidatorContext context) {
        return value == null || this.test.test(this.cmp.compare(value, this.now.apply(context.getClockProvider().getClock())));
    }
}

