/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import java.lang.annotation.Annotation;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Pattern;
import org.apache.bval.util.Validate;

public abstract class AbstractPatternValidator<A extends Annotation, T extends CharSequence>
implements ConstraintValidator<A, T> {
    private final Function<A, PatternDescriptor> toDescriptor;
    protected Pattern pattern;

    protected AbstractPatternValidator(Function<A, PatternDescriptor> toDescriptor) {
        this.toDescriptor = Validate.notNull(toDescriptor);
    }

    @Override
    public void initialize(A constraintAnnotation) {
        ConstraintValidator.super.initialize(constraintAnnotation);
        PatternDescriptor pd = this.toDescriptor.apply(constraintAnnotation);
        Pattern.Flag[] flags = pd.flags();
        int intFlag = 0;
        for (Pattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        try {
            this.pattern = Pattern.compile(pd.regexp(), intFlag);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regular expression.", e);
        }
    }

    @Override
    public boolean isValid(T value, ConstraintValidatorContext context) {
        return value == null || this.pattern.matcher((CharSequence)value).matches();
    }

    public static interface PatternDescriptor {
        public String regexp();

        public Pattern.Flag[] flags();
    }
}

