/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ShowCatalogs
extends Statement {
    private final Optional<String> likePattern;
    private final Optional<String> escape;

    public ShowCatalogs(Optional<String> likePattern, Optional<String> escape) {
        this(Optional.empty(), likePattern, escape);
    }

    public ShowCatalogs(NodeLocation location, Optional<String> likePattern, Optional<String> escape) {
        this(Optional.of(location), likePattern, escape);
    }

    public ShowCatalogs(Optional<NodeLocation> location, Optional<String> likePattern, Optional<String> escape) {
        super(location);
        this.likePattern = Objects.requireNonNull(likePattern, "likePattern is null");
        this.escape = Objects.requireNonNull(escape, "escape is null");
    }

    public Optional<String> getLikePattern() {
        return this.likePattern;
    }

    public Optional<String> getEscape() {
        return this.escape;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowCatalogs(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.likePattern, this.escape);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowCatalogs o = (ShowCatalogs)obj;
        return Objects.equals(this.likePattern, o.likePattern) && Objects.equals(this.escape, o.escape);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("likePattern", this.likePattern).add("escape", this.escape).toString();
    }
}

