/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.PrincipalSpecification;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SetSchemaAuthorization
extends Statement {
    private final QualifiedName source;
    private final PrincipalSpecification principal;

    public SetSchemaAuthorization(QualifiedName source, PrincipalSpecification principal) {
        this(Optional.empty(), source, principal);
    }

    public SetSchemaAuthorization(NodeLocation location, QualifiedName source, PrincipalSpecification principal) {
        this(Optional.of(location), source, principal);
    }

    private SetSchemaAuthorization(Optional<NodeLocation> location, QualifiedName source, PrincipalSpecification principal) {
        super(location);
        this.source = Objects.requireNonNull(source, "source is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
    }

    public QualifiedName getSource() {
        return this.source;
    }

    public PrincipalSpecification getPrincipal() {
        return this.principal;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetSchemaAuthorization(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.principal);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetSchemaAuthorization o = (SetSchemaAuthorization)obj;
        return Objects.equals(this.source, o.source) && Objects.equals(this.principal, o.principal);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("source", this.source).add("principal", this.principal).toString();
    }
}

