/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SetRole
extends Statement {
    private final Type type;
    private final Optional<Identifier> role;

    public SetRole(Type type, Optional<Identifier> role) {
        this(Optional.empty(), type, role);
    }

    public SetRole(NodeLocation location, Type type, Optional<Identifier> role) {
        this(Optional.of(location), type, role);
    }

    private SetRole(Optional<NodeLocation> location, Type type, Optional<Identifier> role) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.role = Objects.requireNonNull(role, "role is null");
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Identifier> getRole() {
        return this.role;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetRole(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetRole setRole = (SetRole)o;
        return this.type == setRole.type && Objects.equals(this.role, setRole.role);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.role});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("role", this.role).toString();
    }

    public static enum Type {
        ROLE,
        ALL,
        NONE;

    }
}

