/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RenameColumn
extends Statement {
    private final QualifiedName table;
    private final Identifier source;
    private final Identifier target;

    public RenameColumn(QualifiedName table, Identifier source, Identifier target) {
        this(Optional.empty(), table, source, target);
    }

    public RenameColumn(NodeLocation location, QualifiedName table, Identifier source, Identifier target) {
        this(Optional.of(location), table, source, target);
    }

    private RenameColumn(Optional<NodeLocation> location, QualifiedName table, Identifier source, Identifier target) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Identifier getSource() {
        return this.source;
    }

    public Identifier getTarget() {
        return this.target;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameColumn that = (RenameColumn)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.source, this.target);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("table", this.table).add("source", this.source).add("target", this.target).toString();
    }
}

