/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import java.util.List;
import java.util.Optional;

public class FieldReference
extends Expression {
    private final int fieldIndex;

    public FieldReference(int fieldIndex) {
        super(Optional.empty());
        Preconditions.checkArgument(fieldIndex >= 0, "fieldIndex must be >= 0");
        this.fieldIndex = fieldIndex;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFieldReference(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldReference that = (FieldReference)o;
        return this.fieldIndex == that.fieldIndex;
    }

    @Override
    public int hashCode() {
        return this.fieldIndex;
    }
}

