/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.parser;

import io.prestosql.sql.parser.AntlrATNCacheFields;
import io.prestosql.sql.parser.SqlBaseLexer;
import io.prestosql.sql.parser.SqlBaseParser;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RefreshableSqlBaseParserInitializer
implements BiConsumer<SqlBaseLexer, SqlBaseParser> {
    private final AtomicReference<SqlBaseParserAndLexerATNCaches> caches = new AtomicReference();

    public RefreshableSqlBaseParserInitializer() {
        this.refresh();
    }

    public void refresh() {
        this.caches.set(new SqlBaseParserAndLexerATNCaches());
    }

    @Override
    public void accept(SqlBaseLexer lexer, SqlBaseParser parser) {
        SqlBaseParserAndLexerATNCaches caches = this.caches.get();
        caches.lexer.configureLexer(lexer);
        caches.parser.configureParser(parser);
    }

    private static final class SqlBaseParserAndLexerATNCaches {
        public final AntlrATNCacheFields lexer = new AntlrATNCacheFields(SqlBaseLexer._ATN);
        public final AntlrATNCacheFields parser = new AntlrATNCacheFields(SqlBaseParser._ATN);

        private SqlBaseParserAndLexerATNCaches() {
        }
    }
}

