/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.sql.ExpressionFormatter;
import io.prestosql.sql.tree.AddColumn;
import io.prestosql.sql.tree.AliasedRelation;
import io.prestosql.sql.tree.AllColumns;
import io.prestosql.sql.tree.Analyze;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Call;
import io.prestosql.sql.tree.CallArgument;
import io.prestosql.sql.tree.ColumnDefinition;
import io.prestosql.sql.tree.Comment;
import io.prestosql.sql.tree.Commit;
import io.prestosql.sql.tree.CreateRole;
import io.prestosql.sql.tree.CreateSchema;
import io.prestosql.sql.tree.CreateTable;
import io.prestosql.sql.tree.CreateTableAsSelect;
import io.prestosql.sql.tree.CreateView;
import io.prestosql.sql.tree.Deallocate;
import io.prestosql.sql.tree.Delete;
import io.prestosql.sql.tree.DescribeInput;
import io.prestosql.sql.tree.DescribeOutput;
import io.prestosql.sql.tree.DropColumn;
import io.prestosql.sql.tree.DropRole;
import io.prestosql.sql.tree.DropSchema;
import io.prestosql.sql.tree.DropTable;
import io.prestosql.sql.tree.DropView;
import io.prestosql.sql.tree.Except;
import io.prestosql.sql.tree.Execute;
import io.prestosql.sql.tree.Explain;
import io.prestosql.sql.tree.ExplainFormat;
import io.prestosql.sql.tree.ExplainOption;
import io.prestosql.sql.tree.ExplainType;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FetchFirst;
import io.prestosql.sql.tree.Grant;
import io.prestosql.sql.tree.GrantRoles;
import io.prestosql.sql.tree.GrantorSpecification;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Insert;
import io.prestosql.sql.tree.Intersect;
import io.prestosql.sql.tree.Isolation;
import io.prestosql.sql.tree.Join;
import io.prestosql.sql.tree.JoinCriteria;
import io.prestosql.sql.tree.JoinOn;
import io.prestosql.sql.tree.JoinUsing;
import io.prestosql.sql.tree.Lateral;
import io.prestosql.sql.tree.LikeClause;
import io.prestosql.sql.tree.Limit;
import io.prestosql.sql.tree.NaturalJoin;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Offset;
import io.prestosql.sql.tree.OrderBy;
import io.prestosql.sql.tree.Prepare;
import io.prestosql.sql.tree.PrincipalSpecification;
import io.prestosql.sql.tree.Property;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.QuerySpecification;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.RenameColumn;
import io.prestosql.sql.tree.RenameSchema;
import io.prestosql.sql.tree.RenameTable;
import io.prestosql.sql.tree.RenameView;
import io.prestosql.sql.tree.ResetSession;
import io.prestosql.sql.tree.Revoke;
import io.prestosql.sql.tree.RevokeRoles;
import io.prestosql.sql.tree.Rollback;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.SampledRelation;
import io.prestosql.sql.tree.Select;
import io.prestosql.sql.tree.SelectItem;
import io.prestosql.sql.tree.SetPath;
import io.prestosql.sql.tree.SetRole;
import io.prestosql.sql.tree.SetSchemaAuthorization;
import io.prestosql.sql.tree.SetSession;
import io.prestosql.sql.tree.ShowCatalogs;
import io.prestosql.sql.tree.ShowColumns;
import io.prestosql.sql.tree.ShowCreate;
import io.prestosql.sql.tree.ShowFunctions;
import io.prestosql.sql.tree.ShowGrants;
import io.prestosql.sql.tree.ShowRoleGrants;
import io.prestosql.sql.tree.ShowRoles;
import io.prestosql.sql.tree.ShowSchemas;
import io.prestosql.sql.tree.ShowSession;
import io.prestosql.sql.tree.ShowStats;
import io.prestosql.sql.tree.ShowTables;
import io.prestosql.sql.tree.SingleColumn;
import io.prestosql.sql.tree.StartTransaction;
import io.prestosql.sql.tree.Table;
import io.prestosql.sql.tree.TableSubquery;
import io.prestosql.sql.tree.TransactionAccessMode;
import io.prestosql.sql.tree.TransactionMode;
import io.prestosql.sql.tree.Union;
import io.prestosql.sql.tree.Unnest;
import io.prestosql.sql.tree.Values;
import io.prestosql.sql.tree.With;
import io.prestosql.sql.tree.WithQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class SqlFormatter {
    private static final String INDENT = "   ";

    private SqlFormatter() {
    }

    public static String formatSql(Node root) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder).process(root, 0);
        return builder.toString();
    }

    static String formatName(QualifiedName name) {
        return name.getOriginalParts().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining("."));
    }

    private static void appendAliasColumns(StringBuilder builder, List<Identifier> columns) {
        if (columns != null && !columns.isEmpty()) {
            String formattedColumns = columns.stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", "));
            builder.append(" (").append(formattedColumns).append(')');
        }
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;

        public Formatter(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            Preconditions.checkArgument(indent == 0, "visitExpression should only be called at root");
            this.builder.append(ExpressionFormatter.formatExpression(node));
            return null;
        }

        @Override
        protected Void visitUnnest(Unnest node, Integer indent) {
            this.builder.append("UNNEST(").append(node.getExpressions().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", "))).append(")");
            if (node.isWithOrdinality()) {
                this.builder.append(" WITH ORDINALITY");
            }
            return null;
        }

        @Override
        protected Void visitLateral(Lateral node, Integer indent) {
            this.append(indent, "LATERAL (");
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ")");
            return null;
        }

        @Override
        protected Void visitPrepare(Prepare node, Integer indent) {
            this.append(indent, "PREPARE ");
            this.builder.append(node.getName());
            this.builder.append(" FROM");
            this.builder.append("\n");
            this.process(node.getStatement(), indent + 1);
            return null;
        }

        @Override
        protected Void visitDeallocate(Deallocate node, Integer indent) {
            this.append(indent, "DEALLOCATE PREPARE ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExecute(Execute node, Integer indent) {
            this.append(indent, "EXECUTE ");
            this.builder.append(node.getName());
            List<Expression> parameters = node.getParameters();
            if (!parameters.isEmpty()) {
                this.builder.append(" USING ");
                Joiner.on(", ").appendTo(this.builder, (Iterable<?>)parameters);
            }
            return null;
        }

        @Override
        protected Void visitDescribeOutput(DescribeOutput node, Integer indent) {
            this.append(indent, "DESCRIBE OUTPUT ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitDescribeInput(DescribeInput node, Integer indent) {
            this.append(indent, "DESCRIBE INPUT ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            if (node.getWith().isPresent()) {
                With with = node.getWith().get();
                this.append(indent, "WITH");
                if (with.isRecursive()) {
                    this.builder.append(" RECURSIVE");
                }
                this.builder.append("\n  ");
                Iterator<WithQuery> queries = with.getQueries().iterator();
                while (queries.hasNext()) {
                    WithQuery query = queries.next();
                    this.append(indent, ExpressionFormatter.formatExpression(query.getName()));
                    query.getColumnNames().ifPresent(columnNames -> SqlFormatter.appendAliasColumns(this.builder, columnNames));
                    this.builder.append(" AS ");
                    this.process(new TableSubquery(query.getQuery()), indent);
                    this.builder.append('\n');
                    if (!queries.hasNext()) continue;
                    this.builder.append(", ");
                }
            }
            this.processRelation(node.getQueryBody(), indent);
            if (node.getOrderBy().isPresent()) {
                this.process(node.getOrderBy().get(), indent);
            }
            if (node.getOffset().isPresent()) {
                this.process(node.getOffset().get(), indent);
            }
            if (node.getLimit().isPresent()) {
                this.process(node.getLimit().get(), indent);
            }
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            this.process(node.getSelect(), indent);
            if (node.getFrom().isPresent()) {
                this.append(indent, "FROM");
                this.builder.append('\n');
                this.append(indent, "  ");
                this.process(node.getFrom().get(), indent);
            }
            this.builder.append('\n');
            if (node.getWhere().isPresent()) {
                this.append(indent, "WHERE " + ExpressionFormatter.formatExpression(node.getWhere().get())).append('\n');
            }
            if (node.getGroupBy().isPresent()) {
                this.append(indent, "GROUP BY " + (node.getGroupBy().get().isDistinct() ? " DISTINCT " : "") + ExpressionFormatter.formatGroupBy(node.getGroupBy().get().getGroupingElements())).append('\n');
            }
            if (node.getHaving().isPresent()) {
                this.append(indent, "HAVING " + ExpressionFormatter.formatExpression(node.getHaving().get())).append('\n');
            }
            if (node.getOrderBy().isPresent()) {
                this.process(node.getOrderBy().get(), indent);
            }
            if (node.getOffset().isPresent()) {
                this.process(node.getOffset().get(), indent);
            }
            if (node.getLimit().isPresent()) {
                this.process(node.getLimit().get(), indent);
            }
            return null;
        }

        @Override
        protected Void visitOrderBy(OrderBy node, Integer indent) {
            this.append(indent, ExpressionFormatter.formatOrderBy(node)).append('\n');
            return null;
        }

        @Override
        protected Void visitOffset(Offset node, Integer indent) {
            this.append(indent, "OFFSET " + node.getRowCount() + " ROWS").append('\n');
            return null;
        }

        @Override
        protected Void visitFetchFirst(FetchFirst node, Integer indent) {
            this.append(indent, "FETCH FIRST " + node.getRowCount().map(c -> c + " ROWS ").orElse("ROW ")).append(node.isWithTies() ? "WITH TIES" : "ONLY").append('\n');
            return null;
        }

        @Override
        protected Void visitLimit(Limit node, Integer indent) {
            this.append(indent, "LIMIT " + node.getLimit()).append('\n');
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process(Iterables.getOnlyElement(node.getSelectItems()), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatExpression(node.getExpression()));
            if (node.getAlias().isPresent()) {
                this.builder.append(' ').append(ExpressionFormatter.formatExpression(node.getAlias().get()));
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer context) {
            node.getTarget().ifPresent(value -> this.builder.append(ExpressionFormatter.formatExpression(value)).append("."));
            this.builder.append("*");
            if (!node.getAliases().isEmpty()) {
                this.builder.append(" AS (").append(Joiner.on(", ").join(node.getAliases().stream().map(ExpressionFormatter::formatExpression).collect(ImmutableList.toImmutableList()))).append(")");
            }
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            String type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + type;
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append('(');
            }
            this.process(node.getLeft(), indent);
            this.builder.append('\n');
            if (node.getType() == Join.Type.IMPLICIT) {
                this.append(indent, ", ");
            } else {
                this.append(indent, type).append(" JOIN ");
            }
            this.process(node.getRight(), indent);
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                if (criteria instanceof JoinUsing) {
                    JoinUsing using = (JoinUsing)criteria;
                    this.builder.append(" USING (").append(Joiner.on(", ").join(using.getColumns())).append(")");
                } else if (criteria instanceof JoinOn) {
                    JoinOn on = (JoinOn)criteria;
                    this.builder.append(" ON ").append(ExpressionFormatter.formatExpression(on.getExpression()));
                } else if (!(criteria instanceof NaturalJoin)) {
                    throw new UnsupportedOperationException("unknown join criteria: " + criteria);
                }
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append(")");
            }
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.processRelationSuffix(node.getRelation(), indent);
            this.builder.append(' ').append(ExpressionFormatter.formatExpression(node.getAlias()));
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitSampledRelation(SampledRelation node, Integer indent) {
            this.processRelationSuffix(node.getRelation(), indent);
            this.builder.append(" TABLESAMPLE ").append((Object)node.getType()).append(" (").append(node.getSamplePercentage()).append(')');
            return null;
        }

        private void processRelationSuffix(Relation relation, Integer indent) {
            if (relation instanceof AliasedRelation || relation instanceof SampledRelation) {
                this.builder.append("( ");
                this.process(relation, indent + 1);
                this.append(indent, ")");
            } else {
                this.process(relation, indent);
            }
        }

        @Override
        protected Void visitValues(Values node, Integer indent) {
            this.builder.append(" VALUES ");
            boolean first = true;
            for (Expression row : node.getRows()) {
                this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                this.builder.append(ExpressionFormatter.formatExpression(row));
                first = false;
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append('\n');
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ") ");
            return null;
        }

        @Override
        protected Void visitUnion(Union node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("UNION ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitExcept(Except node, Integer indent) {
            this.processRelation(node.getLeft(), indent);
            this.builder.append("EXCEPT ");
            if (!node.isDistinct()) {
                this.builder.append("ALL ");
            }
            this.processRelation(node.getRight(), indent);
            return null;
        }

        @Override
        protected Void visitIntersect(Intersect node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("INTERSECT ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitCreateView(CreateView node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("VIEW ").append(SqlFormatter.formatName(node.getName()));
            node.getComment().ifPresent(comment -> this.builder.append(" COMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            node.getSecurity().ifPresent(security -> this.builder.append(" SECURITY ").append(security.toString()));
            this.builder.append(" AS\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitRenameView(RenameView node, Integer context) {
            this.builder.append("ALTER VIEW ").append(node.getSource()).append(" RENAME TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitDropView(DropView node, Integer context) {
            this.builder.append("DROP VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            if (node.isAnalyze()) {
                this.builder.append("ANALYZE ");
            }
            ArrayList<String> options = new ArrayList<String>();
            for (ExplainOption option : node.getOptions()) {
                if (option instanceof ExplainType) {
                    options.add("TYPE " + (Object)((Object)((ExplainType)option).getType()));
                    continue;
                }
                if (option instanceof ExplainFormat) {
                    options.add("FORMAT " + (Object)((Object)((ExplainFormat)option).getType()));
                    continue;
                }
                throw new UnsupportedOperationException("unhandled explain option: " + option);
            }
            if (!options.isEmpty()) {
                this.builder.append("(");
                Joiner.on(", ").appendTo(this.builder, (Iterable<?>)options);
                this.builder.append(")");
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitShowCatalogs(ShowCatalogs node, Integer context) {
            this.builder.append("SHOW CATALOGS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowSchemas(ShowSchemas node, Integer context) {
            this.builder.append("SHOW SCHEMAS");
            if (node.getCatalog().isPresent()) {
                this.builder.append(" FROM ").append(node.getCatalog().get());
            }
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowTables(ShowTables node, Integer context) {
            this.builder.append("SHOW TABLES");
            node.getSchema().ifPresent(value -> this.builder.append(" FROM ").append(SqlFormatter.formatName(value)));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowCreate(ShowCreate node, Integer context) {
            if (node.getType() == ShowCreate.Type.TABLE) {
                this.builder.append("SHOW CREATE TABLE ").append(SqlFormatter.formatName(node.getName()));
            } else if (node.getType() == ShowCreate.Type.VIEW) {
                this.builder.append("SHOW CREATE VIEW ").append(SqlFormatter.formatName(node.getName()));
            }
            return null;
        }

        @Override
        protected Void visitShowColumns(ShowColumns node, Integer context) {
            this.builder.append("SHOW COLUMNS FROM ").append(SqlFormatter.formatName(node.getTable()));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowStats(ShowStats node, Integer context) {
            this.builder.append("SHOW STATS FOR ");
            this.process(node.getRelation(), 0);
            return null;
        }

        @Override
        protected Void visitShowFunctions(ShowFunctions node, Integer context) {
            this.builder.append("SHOW FUNCTIONS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowSession(ShowSession node, Integer context) {
            this.builder.append("SHOW SESSION");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitDelete(Delete node, Integer context) {
            this.builder.append("DELETE FROM ").append(SqlFormatter.formatName(node.getTable().getName()));
            if (node.getWhere().isPresent()) {
                this.builder.append(" WHERE ").append(ExpressionFormatter.formatExpression(node.getWhere().get()));
            }
            return null;
        }

        @Override
        protected Void visitCreateSchema(CreateSchema node, Integer context) {
            this.builder.append("CREATE SCHEMA ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSchemaName()));
            if (node.getPrincipal().isPresent()) {
                this.builder.append("\nAUTHORIZATION ").append(Formatter.formatPrincipal(node.getPrincipal().get()));
            }
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitDropSchema(DropSchema node, Integer context) {
            this.builder.append("DROP SCHEMA ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSchemaName())).append(" ").append(node.isCascade() ? "CASCADE" : "RESTRICT");
            return null;
        }

        @Override
        protected Void visitRenameSchema(RenameSchema node, Integer context) {
            this.builder.append("ALTER SCHEMA ").append(SqlFormatter.formatName(node.getSource())).append(" RENAME TO ").append(ExpressionFormatter.formatExpression(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitSetSchemaAuthorization(SetSchemaAuthorization node, Integer context) {
            this.builder.append("ALTER SCHEMA ").append(SqlFormatter.formatName(node.getSource())).append(" SET AUTHORIZATION ").append(Formatter.formatPrincipal(node.getPrincipal()));
            return null;
        }

        @Override
        protected Void visitCreateTableAsSelect(CreateTableAsSelect node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            if (node.getColumnAliases().isPresent()) {
                String columnList = node.getColumnAliases().get().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", "));
                this.builder.append(String.format("( %s )", columnList));
            }
            if (node.getComment().isPresent()) {
                this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(node.getComment().get()));
            }
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
            if (!node.isWithData()) {
                this.builder.append(" WITH NO DATA");
            }
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            String tableName = SqlFormatter.formatName(node.getName());
            this.builder.append(tableName).append(" (\n");
            String elementIndent = Formatter.indentString(indent + 1);
            String columnList = node.getElements().stream().map(element -> {
                if (element instanceof ColumnDefinition) {
                    ColumnDefinition column = (ColumnDefinition)element;
                    return elementIndent + this.formatColumnDefinition(column);
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    StringBuilder builder = new StringBuilder(elementIndent);
                    builder.append("LIKE ").append(SqlFormatter.formatName(likeClause.getTableName()));
                    if (likeClause.getPropertiesOption().isPresent()) {
                        builder.append(" ").append(likeClause.getPropertiesOption().get().name()).append(" PROPERTIES");
                    }
                    return builder.toString();
                }
                throw new UnsupportedOperationException("unknown table element: " + element);
            }).collect(Collectors.joining(",\n"));
            this.builder.append(columnList);
            this.builder.append("\n").append(")");
            if (node.getComment().isPresent()) {
                this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(node.getComment().get()));
            }
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        private String formatPropertiesMultiLine(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            String propertyList = properties.stream().map(element -> SqlFormatter.INDENT + ExpressionFormatter.formatExpression(element.getName()) + " = " + ExpressionFormatter.formatExpression(element.getValue())).collect(Collectors.joining(",\n"));
            return "\nWITH (\n" + propertyList + "\n)";
        }

        private String formatPropertiesSingleLine(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            String propertyList = properties.stream().map(element -> ExpressionFormatter.formatExpression(element.getName()) + " = " + ExpressionFormatter.formatExpression(element.getValue())).collect(Collectors.joining(", "));
            return " WITH ( " + propertyList + " )";
        }

        private String formatColumnDefinition(ColumnDefinition column) {
            StringBuilder sb = new StringBuilder().append(ExpressionFormatter.formatExpression(column.getName())).append(" ").append(column.getType());
            if (!column.isNullable()) {
                sb.append(" NOT NULL");
            }
            column.getComment().ifPresent(comment -> sb.append(" COMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            sb.append(this.formatPropertiesSingleLine(column.getProperties()));
            return sb.toString();
        }

        private static String formatGrantor(GrantorSpecification grantor) {
            GrantorSpecification.Type type = grantor.getType();
            switch (type) {
                case CURRENT_ROLE: 
                case CURRENT_USER: {
                    return type.name();
                }
                case PRINCIPAL: {
                    return Formatter.formatPrincipal(grantor.getPrincipal().get());
                }
            }
            throw new IllegalArgumentException("Unsupported principal type: " + (Object)((Object)type));
        }

        private static String formatPrincipal(PrincipalSpecification principal) {
            PrincipalSpecification.Type type = principal.getType();
            switch (type) {
                case UNSPECIFIED: {
                    return principal.getName().toString();
                }
                case USER: 
                case ROLE: {
                    return String.format("%s %s", type.name(), principal.getName().toString());
                }
            }
            throw new IllegalArgumentException("Unsupported principal type: " + (Object)((Object)type));
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer context) {
            this.builder.append("DROP TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getTableName());
            return null;
        }

        @Override
        protected Void visitRenameTable(RenameTable node, Integer context) {
            this.builder.append("ALTER TABLE ").append(node.getSource()).append(" RENAME TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitComment(Comment node, Integer context) {
            String comment = node.getComment().isPresent() ? ExpressionFormatter.formatStringLiteral(node.getComment().get()) : "NULL";
            switch (node.getType()) {
                case TABLE: {
                    this.builder.append("COMMENT ON TABLE ").append(node.getName()).append(" IS ").append(comment);
                    break;
                }
                case COLUMN: {
                    this.builder.append("COMMENT ON COLUMN ").append(node.getName()).append(" IS ").append(comment);
                }
            }
            return null;
        }

        @Override
        protected Void visitRenameColumn(RenameColumn node, Integer context) {
            this.builder.append("ALTER TABLE ").append(node.getTable()).append(" RENAME COLUMN ").append(node.getSource()).append(" TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitDropColumn(DropColumn node, Integer context) {
            this.builder.append("ALTER TABLE ").append(SqlFormatter.formatName(node.getTable())).append(" DROP COLUMN ").append(ExpressionFormatter.formatExpression(node.getColumn()));
            return null;
        }

        @Override
        protected Void visitAnalyze(Analyze node, Integer context) {
            this.builder.append("ANALYZE ").append(SqlFormatter.formatName(node.getTableName()));
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitAddColumn(AddColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ").append(node.getName()).append(" ADD COLUMN ").append(this.formatColumnDefinition(node.getColumn()));
            return null;
        }

        @Override
        protected Void visitInsert(Insert node, Integer indent) {
            this.builder.append("INSERT INTO ").append(node.getTarget());
            if (node.getColumns().isPresent()) {
                this.builder.append(" (").append(Joiner.on(", ").join((Iterable)node.getColumns().get())).append(")");
            }
            this.builder.append("\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        public Void visitSetSession(SetSession node, Integer context) {
            this.builder.append("SET SESSION ").append(node.getName()).append(" = ").append(ExpressionFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        public Void visitResetSession(ResetSession node, Integer context) {
            this.builder.append("RESET SESSION ").append(node.getName());
            return null;
        }

        @Override
        protected Void visitCallArgument(CallArgument node, Integer indent) {
            if (node.getName().isPresent()) {
                this.builder.append(node.getName().get()).append(" => ");
            }
            this.builder.append(ExpressionFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        protected Void visitCall(Call node, Integer indent) {
            this.builder.append("CALL ").append(node.getName()).append("(");
            Iterator<CallArgument> arguments = node.getArguments().iterator();
            while (arguments.hasNext()) {
                this.process(arguments.next(), indent);
                if (!arguments.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitRow(Row node, Integer indent) {
            this.builder.append("ROW(");
            boolean firstItem = true;
            for (Expression item : node.getItems()) {
                if (!firstItem) {
                    this.builder.append(", ");
                }
                this.process(item, indent);
                firstItem = false;
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitStartTransaction(StartTransaction node, Integer indent) {
            this.builder.append("START TRANSACTION");
            Iterator<TransactionMode> iterator = node.getTransactionModes().iterator();
            while (iterator.hasNext()) {
                this.builder.append(" ");
                this.process(iterator.next(), indent);
                if (!iterator.hasNext()) continue;
                this.builder.append(",");
            }
            return null;
        }

        @Override
        protected Void visitIsolationLevel(Isolation node, Integer indent) {
            this.builder.append("ISOLATION LEVEL ").append(node.getLevel().getText());
            return null;
        }

        @Override
        protected Void visitTransactionAccessMode(TransactionAccessMode node, Integer context) {
            this.builder.append(node.isReadOnly() ? "READ ONLY" : "READ WRITE");
            return null;
        }

        @Override
        protected Void visitCommit(Commit node, Integer context) {
            this.builder.append("COMMIT");
            return null;
        }

        @Override
        protected Void visitRollback(Rollback node, Integer context) {
            this.builder.append("ROLLBACK");
            return null;
        }

        @Override
        protected Void visitCreateRole(CreateRole node, Integer context) {
            this.builder.append("CREATE ROLE ").append(node.getName());
            if (node.getGrantor().isPresent()) {
                this.builder.append(" WITH ADMIN ").append(Formatter.formatGrantor(node.getGrantor().get()));
            }
            return null;
        }

        @Override
        protected Void visitDropRole(DropRole node, Integer context) {
            this.builder.append("DROP ROLE ").append(node.getName());
            return null;
        }

        @Override
        protected Void visitGrantRoles(GrantRoles node, Integer context) {
            this.builder.append("GRANT ");
            this.builder.append(node.getRoles().stream().map(Expression::toString).collect(Collectors.joining(", ")));
            this.builder.append(" TO ");
            this.builder.append(node.getGrantees().stream().map(Formatter::formatPrincipal).collect(Collectors.joining(", ")));
            if (node.isAdminOption()) {
                this.builder.append(" WITH ADMIN OPTION");
            }
            if (node.getGrantor().isPresent()) {
                this.builder.append(" GRANTED BY ").append(Formatter.formatGrantor(node.getGrantor().get()));
            }
            return null;
        }

        @Override
        protected Void visitRevokeRoles(RevokeRoles node, Integer context) {
            this.builder.append("REVOKE ");
            if (node.isAdminOption()) {
                this.builder.append("ADMIN OPTION FOR ");
            }
            this.builder.append(node.getRoles().stream().map(Expression::toString).collect(Collectors.joining(", ")));
            this.builder.append(" FROM ");
            this.builder.append(node.getGrantees().stream().map(Formatter::formatPrincipal).collect(Collectors.joining(", ")));
            if (node.getGrantor().isPresent()) {
                this.builder.append(" GRANTED BY ").append(Formatter.formatGrantor(node.getGrantor().get()));
            }
            return null;
        }

        @Override
        protected Void visitSetRole(SetRole node, Integer context) {
            this.builder.append("SET ROLE ");
            SetRole.Type type = node.getType();
            switch (type) {
                case ALL: 
                case NONE: {
                    this.builder.append(type.toString());
                    break;
                }
                case ROLE: {
                    this.builder.append(node.getRole().get());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
                }
            }
            return null;
        }

        @Override
        public Void visitGrant(Grant node, Integer indent) {
            this.builder.append("GRANT ");
            if (node.getPrivileges().isPresent()) {
                this.builder.append(node.getPrivileges().get().stream().collect(Collectors.joining(", ")));
            } else {
                this.builder.append("ALL PRIVILEGES");
            }
            this.builder.append(" ON ");
            if (node.isTable()) {
                this.builder.append("TABLE ");
            }
            this.builder.append(node.getTableName()).append(" TO ").append(Formatter.formatPrincipal(node.getGrantee()));
            if (node.isWithGrantOption()) {
                this.builder.append(" WITH GRANT OPTION");
            }
            return null;
        }

        @Override
        public Void visitRevoke(Revoke node, Integer indent) {
            this.builder.append("REVOKE ");
            if (node.isGrantOptionFor()) {
                this.builder.append("GRANT OPTION FOR ");
            }
            if (node.getPrivileges().isPresent()) {
                this.builder.append(node.getPrivileges().get().stream().collect(Collectors.joining(", ")));
            } else {
                this.builder.append("ALL PRIVILEGES");
            }
            this.builder.append(" ON ");
            if (node.isTable()) {
                this.builder.append("TABLE ");
            }
            this.builder.append(node.getTableName()).append(" FROM ").append(Formatter.formatPrincipal(node.getGrantee()));
            return null;
        }

        @Override
        public Void visitShowGrants(ShowGrants node, Integer indent) {
            this.builder.append("SHOW GRANTS ");
            if (node.getTableName().isPresent()) {
                this.builder.append("ON ");
                if (node.getTable()) {
                    this.builder.append("TABLE ");
                }
                this.builder.append(node.getTableName().get());
            }
            return null;
        }

        @Override
        protected Void visitShowRoles(ShowRoles node, Integer context) {
            this.builder.append("SHOW ");
            if (node.isCurrent()) {
                this.builder.append("CURRENT ");
            }
            this.builder.append("ROLES");
            if (node.getCatalog().isPresent()) {
                this.builder.append(" FROM ").append(node.getCatalog().get());
            }
            return null;
        }

        @Override
        protected Void visitShowRoleGrants(ShowRoleGrants node, Integer context) {
            this.builder.append("SHOW ROLE GRANTS");
            if (node.getCatalog().isPresent()) {
                this.builder.append(" FROM ").append(node.getCatalog().get());
            }
            return null;
        }

        @Override
        public Void visitSetPath(SetPath node, Integer indent) {
            this.builder.append("SET PATH ");
            this.builder.append(Joiner.on(", ").join(node.getPathSpecification().getPath()));
            return null;
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(((Table)relation).getName()).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat(SqlFormatter.INDENT, indent);
        }
    }
}

