/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.io.Closer;
import io.prestosql.cli.InputHighlighter;
import io.prestosql.cli.InputParser;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import org.jline.reader.Completer;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class InputReader
implements Closeable {
    private final LineReader reader;

    public InputReader(Path historyFile, Completer ... completers) throws IOException {
        Terminal terminal = TerminalBuilder.builder().name("Presto").build();
        this.reader = LineReaderBuilder.builder().terminal(terminal).variable("history-file", historyFile).variable("secondary-prompt-pattern", InputReader.colored("%P -> ")).variable("blink-matching-paren", 0).parser(new InputParser()).highlighter(new InputHighlighter()).completer(new AggregateCompleter(completers)).build();
        this.reader.unsetOpt(LineReader.Option.HISTORY_TIMESTAMPED);
    }

    public String readLine(String prompt, String buffer) {
        return this.reader.readLine(InputReader.colored(prompt), null, buffer);
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(this.getHistory()::save);
            closer.register(this.getTerminal());
        }
    }

    public History getHistory() {
        return this.reader.getHistory();
    }

    public Terminal getTerminal() {
        return this.reader.getTerminal();
    }

    private static String colored(String value) {
        return new AttributedString(value, AttributedStyle.DEFAULT.foreground(8)).toAnsi();
    }
}

