/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import io.prestosql.cli.Console;
import io.prestosql.sql.parser.StatementSplitter;
import java.util.Locale;
import java.util.Set;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.DefaultParser;

public class InputParser
implements Parser {
    private static final Set<String> SPECIAL = ImmutableSet.of("exit", "quit", "history", "help");

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        String command = CharMatcher.whitespace().trimFrom(line);
        if (command.isEmpty() || SPECIAL.contains(command.toLowerCase(Locale.ENGLISH))) {
            return new DefaultParser().parse(line, cursor, context);
        }
        StatementSplitter splitter = new StatementSplitter(line, Console.STATEMENT_DELIMITERS);
        if (splitter.getCompleteStatements().isEmpty()) {
            throw new EOFError(-1, -1, null);
        }
        return new DefaultParser().parse(line, cursor, context);
    }

    @Override
    public boolean isEscapeChar(char ch) {
        return false;
    }
}

