/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration.validation;

import com.google.common.base.Verify;
import io.airlift.configuration.validation.FileExists;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class FileExistsValidator
implements ConstraintValidator<FileExists, Object> {
    @Override
    public void initialize(FileExists ignored) {
        Verify.verify(ignored.message().isEmpty(), "FileExists.message cannot be specified", new Object[0]);
    }

    @Override
    public boolean isValid(Object path, ConstraintValidatorContext context) {
        if (path == null) {
            return true;
        }
        boolean fileExists = FileExistsValidator.exists(path);
        if (!fileExists) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("file does not exist: " + path).addConstraintViolation();
        }
        return fileExists;
    }

    private static boolean exists(Object path) {
        if (path instanceof String) {
            return Files.exists(Paths.get((String)path, new String[0]), new LinkOption[0]);
        }
        if (path instanceof Path) {
            return Files.exists((Path)path, new LinkOption[0]);
        }
        if (path instanceof File) {
            return ((File)path).exists();
        }
        throw new IllegalArgumentException("Unsupported type for @FileExists: " + path.getClass().getName());
    }
}

