/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class DeclaredMembers {
    private static final Ordering<Class<?>> CLASS_ORDERING = new Ordering<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Ordering<Field> FIELD_ORDERING = new Ordering<Field>(){

        @Override
        public int compare(Field left, Field right) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)left.getName()), (Comparable<?>)((Object)right.getName())).compare(left.getType(), right.getType(), CLASS_ORDERING).result();
        }
    };
    private static final Ordering<Method> METHOD_ORDERING = new Ordering<Method>(){

        @Override
        public int compare(Method left, Method right) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)left.getName()), (Comparable<?>)((Object)right.getName())).compare(left.getReturnType(), right.getReturnType(), CLASS_ORDERING).compare(Arrays.asList(left.getParameterTypes()), Arrays.asList(right.getParameterTypes()), CLASS_ORDERING.lexicographical()).result();
        }
    };

    private DeclaredMembers() {
    }

    public static Field[] getDeclaredFields(Class<?> type) {
        Field[] fields = type.getDeclaredFields();
        Arrays.sort(fields, FIELD_ORDERING);
        return fields;
    }

    public static Method[] getDeclaredMethods(Class<?> type) {
        Method[] methods = type.getDeclaredMethods();
        Arrays.sort(methods, METHOD_ORDERING);
        return methods;
    }
}

