/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.Key;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiFunction;
import javax.management.ObjectName;
import org.weakref.jmx.ObjectNameGenerator;
import org.weakref.jmx.internal.guava.reflect.TypeParameter;
import org.weakref.jmx.internal.guava.reflect.TypeToken;

class MapMapping<K, V> {
    private final BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> objectNameFunction;
    private final Class<K> keyClass;
    private final Class<V> valueClass;

    MapMapping(Class<K> keyClass, Class<V> valueClass, BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> objectNameFunction) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.objectNameFunction = objectNameFunction;
    }

    public BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> getObjectNameFunction() {
        return this.objectNameFunction;
    }

    public Key<Map<K, V>> getKey() {
        return Key.get(MapMapping.mapOf(this.keyClass, this.valueClass));
    }

    private static <K, V> Type mapOf(Class<K> keyClass, Class<V> valueClass) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, TypeToken.of(keyClass)).where(new TypeParameter<V>(){}, TypeToken.of(valueClass)).getType();
    }
}

