/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.weakref.jmx.AnnotationUtils;
import org.weakref.jmx.MBean;
import org.weakref.jmx.MBeanAttribute;
import org.weakref.jmx.MBeanAttributeBuilder;
import org.weakref.jmx.MBeanFeature;
import org.weakref.jmx.MBeanOperation;
import org.weakref.jmx.MBeanOperationBuilder;
import org.weakref.jmx.ReflectionUtils;

final class MBeanBuilder {
    private final String className;
    private final List<MBeanAttributeBuilder> attributeBuilders = new ArrayList<MBeanAttributeBuilder>();
    private final List<MBeanOperationBuilder> operationBuilders = new ArrayList<MBeanOperationBuilder>();
    private String description;

    private MBeanBuilder(String className) {
        this.className = className;
    }

    public static MBeanBuilder from(String className) {
        return new MBeanBuilder(className);
    }

    public static MBeanBuilder from(Object object) {
        return new MBeanBuilder(object);
    }

    public MBeanBuilder(Object target) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        TreeMap<String, MBeanAttributeBuilder> attributeBuilders = new TreeMap<String, MBeanAttributeBuilder>();
        for (Map.Entry<Method, Method> entry : AnnotationUtils.findManagedMethods(target.getClass()).entrySet()) {
            Method concreteMethod = entry.getKey();
            Method annotatedMethod = entry.getValue();
            if (ReflectionUtils.isGetter(concreteMethod) || ReflectionUtils.isSetter(concreteMethod)) {
                String attributeName = ReflectionUtils.getAttributeName(concreteMethod);
                MBeanAttributeBuilder attributeBuilder = (MBeanAttributeBuilder)attributeBuilders.get(attributeName);
                if (attributeBuilder == null) {
                    attributeBuilder = new MBeanAttributeBuilder().named(attributeName).onInstance(target);
                }
                if (ReflectionUtils.isGetter(concreteMethod)) {
                    attributeBuilder = attributeBuilder.withConcreteGetter(concreteMethod).withAnnotatedGetter(annotatedMethod);
                } else if (ReflectionUtils.isSetter(concreteMethod)) {
                    attributeBuilder = attributeBuilder.withConcreteSetter(concreteMethod).withAnnotatedSetter(annotatedMethod);
                }
                attributeBuilders.put(attributeName, attributeBuilder);
                continue;
            }
            this.addOperation().onInstance(target).withConcreteMethod(concreteMethod).withAnnotatedMethod(annotatedMethod).build();
        }
        this.attributeBuilders.addAll(attributeBuilders.values());
        this.className = target.getClass().getName();
        this.description = AnnotationUtils.getDescription(target.getClass().getAnnotations());
    }

    public MBeanBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public MBeanAttributeBuilder addAttribute() {
        MBeanAttributeBuilder builder = new MBeanAttributeBuilder();
        this.attributeBuilders.add(builder);
        return builder;
    }

    public MBeanOperationBuilder addOperation() {
        MBeanOperationBuilder builder = new MBeanOperationBuilder();
        this.operationBuilders.add(builder);
        return builder;
    }

    public MBean build() {
        ArrayList<MBeanAttribute> attributes = new ArrayList<MBeanAttribute>();
        ArrayList<MBeanOperation> operations = new ArrayList<MBeanOperation>();
        for (MBeanAttributeBuilder attributeBuilder : this.attributeBuilders) {
            for (MBeanFeature mBeanFeature : attributeBuilder.build()) {
                if (mBeanFeature instanceof MBeanAttribute) {
                    attributes.add((MBeanAttribute)mBeanFeature);
                }
                if (!(mBeanFeature instanceof MBeanOperation)) continue;
                operations.add((MBeanOperation)mBeanFeature);
            }
        }
        for (MBeanOperationBuilder operationBuilder : this.operationBuilders) {
            operations.add(operationBuilder.build());
        }
        return new MBean(this.className, this.description, attributes, operations);
    }
}

