/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.executable.ExecutableType;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;

public class ExecutableTypes {
    private static final Set<ExecutableType> ALL_TYPES = Collections.unmodifiableSet(EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS, ExecutableType.GETTER_METHODS));
    private static final Set<ExecutableType> IMPLICIT_TYPES = Collections.unmodifiableSet(EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS));

    public static Set<ExecutableType> interpret(Collection<ExecutableType> executableTypes) {
        Validate.notNull(executableTypes);
        if (executableTypes.isEmpty()) {
            return Collections.emptySet();
        }
        EnumSet<ExecutableType> result = EnumSet.copyOf(executableTypes);
        if (result.contains((Object)ExecutableType.ALL)) {
            return ALL_TYPES;
        }
        if (result.remove((Object)ExecutableType.IMPLICIT)) {
            if (!result.isEmpty()) {
                Exceptions.raise(IllegalArgumentException::new, "Mixing %s with other %ss is illegal.", new Object[]{ExecutableType.IMPLICIT, ExecutableType.class.getSimpleName()});
            }
            return IMPLICIT_TYPES;
        }
        result.remove((Object)ExecutableType.NONE);
        return result.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(result);
    }

    public static Set<ExecutableType> interpret(ExecutableType ... executableTypes) {
        return ExecutableTypes.interpret(Arrays.asList(executableTypes));
    }

    private ExecutableTypes() {
    }
}

