/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.job;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;
import javax.validation.Path;
import org.apache.bval.jsr.ApacheFactoryContext;
import org.apache.bval.jsr.job.ValidationJob;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;

public abstract class ValidateExecutable<E extends Executable, T>
extends ValidationJob<T> {
    private static final Function<Method, Path.Node> METHOD_NODE = m3 -> new NodeImpl.MethodNodeImpl(m3.getName(), Arrays.asList(m3.getParameterTypes()));
    private static final Function<Constructor<?>, Path.Node> CONSTRUCTOR_NODE = c -> new NodeImpl.ConstructorNodeImpl(c.getDeclaringClass().getSimpleName(), Arrays.asList(c.getParameterTypes()));
    protected final E executable;
    private final Function<E, Path.Node> executableNode;

    public ValidateExecutable(ApacheFactoryContext validatorContext, Class<?>[] groups, Meta<E> meta) {
        super(validatorContext, groups);
        this.executable = (Executable)Validate.notNull(meta, IllegalArgumentException::new, "meta", new Object[0]).getHost();
        switch (meta.getElementType()) {
            case CONSTRUCTOR: {
                this.executableNode = CONSTRUCTOR_NODE;
                break;
            }
            case METHOD: {
                this.executableNode = METHOD_NODE;
                break;
            }
            default: {
                throw Exceptions.create(IllegalArgumentException::new, "Unsupported %s: %s", ElementType.class.getSimpleName(), meta);
            }
        }
    }

    protected PathImpl createBasePath() {
        PathImpl path = PathImpl.create();
        path.addNode(this.executableNode.apply(this.executable));
        return path;
    }
}

