/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.validation.metadata.ParameterDescriptor;
import org.apache.bval.jsr.descriptor.CascadableContainerD;
import org.apache.bval.jsr.descriptor.ExecutableD;
import org.apache.bval.jsr.descriptor.MetadataReader;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.TypeUtils;

public class ParameterD<P extends ExecutableD<?, ?, P>>
extends CascadableContainerD<P, Parameter>
implements ParameterDescriptor {
    private final int index;
    private final String name;
    private final Class<?> type;

    ParameterD(Meta.ForParameter meta, int index, MetadataReader.ForContainer<Parameter> reader, P parent) {
        super(reader, parent);
        Validate.isTrue(index >= 0 && index < ((Parameter)meta.getHost()).getDeclaringExecutable().getParameterCount(), "Invalid parameter index %d", index);
        this.index = index;
        this.name = reader.meta.getName();
        this.type = this.resolveType();
    }

    @Override
    public Class<?> getElementClass() {
        return this.type;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private Class<?> resolveType() {
        Class<?> declaringClass = ((Parameter)this.getTarget()).getDeclaringExecutable().getDeclaringClass();
        Type t = ((Parameter)this.getTarget()).getParameterizedType();
        int arrayDepth = 0;
        while (t instanceof GenericArrayType) {
            ++arrayDepth;
            t = ((GenericArrayType)t).getGenericComponentType();
        }
        Class<?> result = null;
        while (result == null && (result = TypeUtils.getRawType(t, declaringClass)) == null) {
            if (!(t instanceof TypeVariable)) continue;
            TypeVariable tv = (TypeVariable)t;
            t = tv.getBounds()[0];
        }
        return arrayDepth > 0 ? Array.newInstance(result, new int[arrayDepth]).getClass() : result;
    }
}

