/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import org.apache.bval.jsr.descriptor.BeanD;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.Finder;
import org.apache.bval.jsr.descriptor.MetadataReader;
import org.apache.bval.jsr.groups.GroupStrategy;
import org.apache.bval.jsr.groups.GroupsComputer;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.TypeUtils;

public abstract class ElementD<E extends AnnotatedElement, R extends MetadataReader.ForElement<E, ?>>
implements ElementDescriptor {
    protected final Type genericType;
    final GroupsComputer groupsComputer;
    private final Meta<E> meta;
    private final Set<ConstraintD<?>> constraints;

    protected ElementD(R reader) {
        Validate.notNull(reader, "reader", new Object[0]);
        this.meta = ((MetadataReader.ForElement)reader).meta;
        this.genericType = ((MetadataReader.ForElement)reader).meta.getType();
        this.constraints = ((MetadataReader.ForElement)reader).getConstraints();
        this.groupsComputer = ((MetadataReader.ForElement)reader).getValidatorFactory().getGroupsComputer();
    }

    @Override
    public final boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    @Override
    public final Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.constraints;
    }

    @Override
    public final ElementDescriptor.ConstraintFinder findConstraints() {
        return new Finder(this.groupsComputer, this);
    }

    public final ElementType getElementType() {
        return this.meta.getElementType();
    }

    public final E getTarget() {
        return this.meta.getHost();
    }

    public final Class<?> getDeclaringClass() {
        return this.meta.getDeclaringClass();
    }

    public abstract Type getGenericType();

    public abstract GroupStrategy getGroupStrategy();

    public String toString() {
        return String.format("%s: %s", this.getClass().getSimpleName(), this.meta.describeHost());
    }

    protected abstract BeanD<?> getBean();

    public static abstract class NonRoot<P extends ElementD<?, ?>, E extends AnnotatedElement, R extends MetadataReader.ForElement<E, ?>>
    extends ElementD<E, R> {
        protected final P parent;

        protected NonRoot(R reader, P parent) {
            super(reader);
            this.parent = (ElementD)Validate.notNull(parent, "parent", new Object[0]);
        }

        public P getParent() {
            return this.parent;
        }

        @Override
        public final Type getGenericType() {
            if (TypeUtils.containsTypeVariables(this.genericType)) {
                Map<TypeVariable<?>, Type> args = TypeUtils.getTypeArguments(((ElementD)this.parent).getGenericType(), Object.class);
                return TypeUtils.unrollVariables(args, this.genericType);
            }
            return this.genericType;
        }

        @Override
        protected final BeanD<?> getBean() {
            return ((ElementD)this.parent).getBean();
        }

        @Override
        public final GroupStrategy getGroupStrategy() {
            return this.getBean().getGroupStrategy();
        }
    }
}

