/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Query;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WithQuery
extends Node {
    private final Identifier name;
    private final Query query;
    private final Optional<List<Identifier>> columnNames;

    public WithQuery(Identifier name, Query query, Optional<List<Identifier>> columnNames) {
        this(Optional.empty(), name, query, columnNames);
    }

    public WithQuery(NodeLocation location, Identifier name, Query query, Optional<List<Identifier>> columnNames) {
        this(Optional.of(location), name, query, columnNames);
    }

    private WithQuery(Optional<NodeLocation> location, Identifier name, Query query, Optional<List<Identifier>> columnNames) {
        super(location);
        this.name = name;
        this.query = Objects.requireNonNull(query, "query is null");
        this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public Optional<List<Identifier>> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWithQuery(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.query);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("query", this.query).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.columnNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WithQuery o = (WithQuery)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.columnNames, o.columnNames);
    }
}

