/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.DataType;
import io.prestosql.sql.tree.DataTypeParameter;
import io.prestosql.sql.tree.Node;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TypeParameter
extends DataTypeParameter {
    private final DataType type;

    public TypeParameter(DataType type) {
        super(Optional.empty());
        this.type = Objects.requireNonNull(type, "value is null");
    }

    public DataType getValue() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of(this.type);
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTypeParameter(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeParameter that = (TypeParameter)o;
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type);
    }
}

