/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowRoles
extends Statement {
    private final Optional<Identifier> catalog;
    private final boolean current;

    public ShowRoles(Optional<Identifier> catalog, boolean current) {
        this(Optional.empty(), catalog, current);
    }

    public ShowRoles(NodeLocation location, Optional<Identifier> catalog, boolean current) {
        this(Optional.of(location), catalog, current);
    }

    public ShowRoles(Optional<NodeLocation> location, Optional<Identifier> catalog, boolean current) {
        super(location);
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.current = current;
    }

    public Optional<Identifier> getCatalog() {
        return this.catalog;
    }

    public boolean isCurrent() {
        return this.current;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowRoles(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalog, this.current);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowRoles o = (ShowRoles)obj;
        return Objects.equals(this.catalog, o.catalog) && this.current == o.current;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("catalog", this.catalog).add("current", this.current).toString();
    }
}

