/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class NodeLocation {
    private final int line;
    private final int charPositionInLine;

    public NodeLocation(int line, int charPositionInLine) {
        Preconditions.checkArgument(line >= 1, "line must be at least one, got: %s", line);
        Preconditions.checkArgument(charPositionInLine >= 0, "charPositionInLine must be at least zero, got: %s", charPositionInLine);
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.charPositionInLine + 1;
    }

    public String toString() {
        return this.line + ":" + this.charPositionInLine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLocation that = (NodeLocation)o;
        return this.line == that.line && this.charPositionInLine == that.charPositionInLine;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.charPositionInLine);
    }
}

