/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InPredicate
extends Expression {
    private final Expression value;
    private final Expression valueList;

    public InPredicate(Expression value, Expression valueList) {
        this(Optional.empty(), value, valueList);
    }

    public InPredicate(NodeLocation location, Expression value, Expression valueList) {
        this(Optional.of(location), value, valueList);
    }

    private InPredicate(Optional<NodeLocation> location, Expression value, Expression valueList) {
        super(location);
        this.value = value;
        this.valueList = valueList;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getValueList() {
        return this.valueList;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInPredicate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.value, this.valueList);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InPredicate that = (InPredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.valueList, that.valueList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.valueList);
    }
}

