/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GroupingElement;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class GroupingSets
extends GroupingElement {
    private final List<List<Expression>> sets;

    public GroupingSets(List<List<Expression>> groupingSets) {
        this(Optional.empty(), groupingSets);
    }

    public GroupingSets(NodeLocation location, List<List<Expression>> sets) {
        this(Optional.of(location), sets);
    }

    private GroupingSets(Optional<NodeLocation> location, List<List<Expression>> sets) {
        super(location);
        Objects.requireNonNull(sets, "sets is null");
        Preconditions.checkArgument(!sets.isEmpty(), "grouping sets cannot be empty");
        this.sets = sets.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
    }

    public List<List<Expression>> getSets() {
        return this.sets;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.sets.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupingSets(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingSets groupingSets = (GroupingSets)o;
        return Objects.equals(this.sets, groupingSets.sets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sets);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("sets", this.sets).toString();
    }
}

