/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GroupingOperation
extends Expression {
    private final List<Expression> groupingColumns;

    public GroupingOperation(Optional<NodeLocation> location, List<QualifiedName> groupingColumns) {
        super(location);
        Objects.requireNonNull(groupingColumns);
        Preconditions.checkArgument(!groupingColumns.isEmpty(), "grouping operation columns cannot be empty");
        this.groupingColumns = groupingColumns.stream().map(DereferenceExpression::from).collect(ImmutableList.toImmutableList());
    }

    public List<Expression> getGroupingColumns() {
        return this.groupingColumns;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupingOperation(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingOperation other = (GroupingOperation)o;
        return Objects.equals(this.groupingColumns, other.groupingColumns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groupingColumns);
    }
}

