/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.DataType;
import io.prestosql.sql.tree.DataTypeParameter;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DateTimeDataType
extends DataType {
    private final Type type;
    private final boolean withTimeZone;
    private final Optional<DataTypeParameter> precision;

    public DateTimeDataType(NodeLocation location, Type type, boolean withTimeZone, Optional<DataTypeParameter> precision) {
        this(Optional.of(location), type, withTimeZone, precision);
    }

    public DateTimeDataType(Optional<NodeLocation> location, Type type, boolean withTimeZone, Optional<DataTypeParameter> precision) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.withTimeZone = withTimeZone;
        this.precision = Objects.requireNonNull(precision, "precision is null");
    }

    public Type getType() {
        return this.type;
    }

    public boolean isWithTimeZone() {
        return this.withTimeZone;
    }

    public Optional<DataTypeParameter> getPrecision() {
        return this.precision;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDateTimeType(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeDataType that = (DateTimeDataType)o;
        return this.withTimeZone == that.withTimeZone && this.type == that.type && this.precision.equals(that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.withTimeZone, this.precision});
    }

    public static enum Type {
        TIMESTAMP,
        TIME;

    }
}

