/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Comment
extends Statement {
    private final Type type;
    private final QualifiedName name;
    private final Optional<String> comment;

    public Comment(Type type, QualifiedName name, Optional<String> comment) {
        this(Optional.empty(), type, name, comment);
    }

    public Comment(NodeLocation location, Type type, QualifiedName name, Optional<String> comment) {
        this(Optional.of(location), type, name, comment);
    }

    private Comment(Optional<NodeLocation> location, Type type, QualifiedName name, Optional<String> comment) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "table is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public Type getType() {
        return this.type;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitComment(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.comment});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Comment o = (Comment)obj;
        return this.type == o.type && Objects.equals(this.name, o.name) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("name", this.name).add("comment", this.comment).toString();
    }

    public static enum Type {
        TABLE;

    }
}

