/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.inject.Key;
import io.airlift.configuration.ConfigurationBinding;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationMetadata;
import io.airlift.configuration.ConfigurationProvider;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;

public class ConfigurationInspector {
    public SortedSet<ConfigRecord<?>> inspect(ConfigurationFactory configurationFactory) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (ConfigurationProvider<?> configurationProvider : configurationFactory.getConfigurationProviders()) {
            ConfigRecord result = new ConfigRecord(configurationFactory, configurationProvider);
            builder.add(result);
        }
        return builder.build();
    }

    private static String getValue(Method getter, Object instance, String defaultValue) {
        if (getter == null || instance == null) {
            return defaultValue;
        }
        try {
            Object value = getter.invoke(instance, new Object[0]);
            if (value == null) {
                return "----";
            }
            if (value instanceof Optional) {
                return ((Optional)value).map(Object::toString).orElse("----");
            }
            return value.toString();
        }
        catch (Throwable e) {
            return "-- ERROR --";
        }
    }

    public static class ConfigAttribute
    implements Comparable<ConfigAttribute> {
        private final String attributeName;
        private final String propertyName;
        private final String defaultValue;
        private final String currentValue;
        private final String description;

        private ConfigAttribute(String attributeName, String propertyName, String defaultValue, String currentValue, String description, boolean securitySensitive) {
            Objects.requireNonNull(attributeName, "attributeName");
            Objects.requireNonNull(propertyName, "propertyName");
            Objects.requireNonNull(defaultValue, "defaultValue");
            Objects.requireNonNull(currentValue, "currentValue");
            Objects.requireNonNull(description, "description");
            this.attributeName = attributeName;
            this.propertyName = propertyName;
            this.defaultValue = securitySensitive && defaultValue != null ? "[REDACTED]" : defaultValue;
            this.currentValue = securitySensitive && currentValue != null ? "[REDACTED]" : currentValue;
            this.description = description;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigAttribute that = (ConfigAttribute)o;
            return this.attributeName.equals(that.attributeName);
        }

        public int hashCode() {
            return this.attributeName.hashCode();
        }

        @Override
        public int compareTo(ConfigAttribute that) {
            return this.attributeName.compareTo(that.attributeName);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("attributeName", this.attributeName).add("propertyName", this.propertyName).add("defaultValue", this.defaultValue).add("currentValue", this.currentValue).add("description", this.description).toString();
        }
    }

    public static class ConfigRecord<T>
    implements Comparable<ConfigRecord<?>> {
        private final Key<T> key;
        private final Class<T> configClass;
        private final String prefix;
        private final SortedSet<ConfigAttribute> attributes;

        private ConfigRecord(ConfigurationFactory configurationFactory, ConfigurationProvider<T> configurationProvider) {
            Objects.requireNonNull(configurationProvider, "configurationProvider");
            ConfigurationBinding<T> configurationBinding = configurationProvider.getConfigurationBinding();
            this.key = configurationBinding.getKey();
            this.configClass = configurationBinding.getConfigClass();
            this.prefix = configurationBinding.getPrefix().orElse(null);
            ConfigurationMetadata<T> metadata = ConfigurationMetadata.getConfigurationMetadata(configurationBinding.getConfigClass());
            T defaults = configurationFactory.getDefaultConfig(configurationBinding.getKey());
            Object instance = null;
            try {
                instance = configurationProvider.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String prefix = configurationBinding.getPrefix().map(value -> value + ".").orElse("");
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
            for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
                String propertyName = prefix + attribute.getInjectionPoint().getProperty();
                Method getter = attribute.getGetter();
                String defaultValue = ConfigurationInspector.getValue(getter, defaults, "-- none --");
                String currentValue = ConfigurationInspector.getValue(getter, instance, "-- n/a --");
                String description = attribute.getDescription();
                if (description == null) {
                    description = "";
                }
                builder.add(new ConfigAttribute(attribute.getName(), propertyName, defaultValue, currentValue, description, attribute.isSecuritySensitive()));
            }
            this.attributes = builder.build();
        }

        public Key<T> getKey() {
            return this.key;
        }

        public Class<T> getConfigClass() {
            return this.configClass;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public SortedSet<ConfigAttribute> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigRecord that = (ConfigRecord)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public int compareTo(ConfigRecord<?> that) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)String.valueOf(this.key.getTypeLiteral().getType())), (Comparable<?>)((Object)String.valueOf(that.key.getTypeLiteral().getType()))).compare((Comparable<?>)((Object)String.valueOf(this.key.getAnnotationType())), (Comparable<?>)((Object)String.valueOf(that.key.getAnnotationType()))).compare(this.key, that.key, Ordering.arbitrary()).result();
        }
    }
}

