/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.configuration.ConfigDefaultsHolder;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationBinding;
import io.airlift.configuration.ConfigurationBindingListener;
import io.airlift.configuration.ConfigurationBindingListenerHolder;
import io.airlift.configuration.ConfigurationMetadata;
import io.airlift.configuration.ConfigurationProvider;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.GlobalDefaults;
import io.airlift.configuration.InvalidConfigurationException;
import io.airlift.configuration.Problems;
import io.airlift.configuration.WarningsMonitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Provider;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;

public class ConfigurationFactory {
    @GuardedBy(value="VALIDATOR")
    private static final Validator VALIDATOR;
    private final Map<String, String> properties;
    private final WarningsMonitor warningsMonitor;
    private final Problems.Monitor monitor;
    private final ConcurrentMap<ConfigurationProvider<?>, Object> instanceCache = new ConcurrentHashMap();
    private final Set<String> usedProperties = Sets.newConcurrentHashSet();
    private final Set<ConfigurationProvider<?>> registeredProviders = Sets.newConcurrentHashSet();
    @GuardedBy(value="this")
    private final List<Consumer<ConfigurationProvider<?>>> configurationBindingListeners = new ArrayList();
    private final ListMultimap<Key<?>, ConfigDefaultsHolder<?>> registeredDefaultConfigs = Multimaps.synchronizedListMultimap(ArrayListMultimap.create());
    private final LoadingCache<Class<?>, ConfigurationMetadata<?>> metadataCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ConfigurationMetadata<?>>(){

        @Override
        public ConfigurationMetadata<?> load(Class<?> configClass) {
            return ConfigurationMetadata.getConfigurationMetadata(configClass, ConfigurationFactory.this.monitor);
        }
    });

    public ConfigurationFactory(Map<String, String> properties) {
        this(properties, null, Problems.NULL_MONITOR);
    }

    public ConfigurationFactory(Map<String, String> properties, WarningsMonitor warningsMonitor) {
        this(properties, warningsMonitor, Problems.NULL_MONITOR);
    }

    @VisibleForTesting
    ConfigurationFactory(Map<String, String> properties, WarningsMonitor warningsMonitor, Problems.Monitor monitor) {
        this.properties = ImmutableMap.copyOf(properties);
        this.warningsMonitor = warningsMonitor;
        this.monitor = monitor;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Beta
    public void consumeProperty(String property) {
        Objects.requireNonNull(property, "property is null");
        this.usedProperties.add(property);
    }

    public Set<String> getUsedProperties() {
        return ImmutableSortedSet.copyOf(this.usedProperties);
    }

    @Beta
    public void registerConfigurationClasses(Module module) {
        this.registerConfigurationClasses(ImmutableList.of(module));
    }

    public void registerConfigurationClasses(Collection<? extends Module> modules) {
        modules.stream().filter(ConfigurationAwareModule.class::isInstance).map(ConfigurationAwareModule.class::cast).forEach(module -> module.setConfigurationFactory(this));
        for (Element element : Elements.getElements(modules)) {
            element.acceptVisitor(new DefaultElementVisitor<Void>(){

                @Override
                public <T> Void visit(Binding<T> binding) {
                    ProviderInstanceBinding providerInstanceBinding;
                    Provider provider;
                    if (binding instanceof InstanceBinding) {
                        InstanceBinding instanceBinding = (InstanceBinding)binding;
                        if (instanceBinding.getInstance() instanceof ConfigurationBindingListenerHolder) {
                            ConfigurationFactory.this.addConfigurationBindingListener(((ConfigurationBindingListenerHolder)instanceBinding.getInstance()).getConfigurationBindingListener());
                        }
                        if (instanceBinding.getInstance() instanceof ConfigDefaultsHolder) {
                            ConfigurationFactory.this.registerConfigDefaults((ConfigDefaultsHolder)instanceBinding.getInstance());
                        }
                    }
                    if (binding instanceof ProviderInstanceBinding && (provider = (providerInstanceBinding = (ProviderInstanceBinding)binding).getUserSuppliedProvider()) instanceof ConfigurationProvider) {
                        ConfigurationFactory.this.registerConfigurationProvider((ConfigurationProvider)provider, Optional.of(binding.getSource()));
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConfigurationProvider(ConfigurationProvider<?> configurationProvider, Optional<Object> bindingSource) {
        configurationProvider.setConfigurationFactory(this);
        configurationProvider.setBindingSource(bindingSource);
        ImmutableList<Object> listeners = ImmutableList.of();
        ConfigurationFactory configurationFactory = this;
        synchronized (configurationFactory) {
            if (this.registeredProviders.add(configurationProvider)) {
                listeners = ImmutableList.copyOf(this.configurationBindingListeners);
            }
        }
        listeners.forEach((Consumer<Object>)((Consumer<Consumer>)listener -> listener.accept(configurationProvider)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationBindingListener(ConfigurationBindingListener listener) {
        ImmutableSet<ConfigurationProvider<?>> currentProviders;
        ConfigurationProviderConsumer consumer = new ConfigurationProviderConsumer(listener);
        ConfigurationFactory configurationFactory = this;
        synchronized (configurationFactory) {
            this.configurationBindingListeners.add(consumer);
            currentProviders = ImmutableSet.copyOf(this.registeredProviders);
        }
        currentProviders.forEach(consumer);
    }

    public List<Message> validateRegisteredConfigurationProvider() {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (ConfigurationProvider configurationProvider : ImmutableList.copyOf(this.registeredProviders)) {
            try {
                configurationProvider.get();
            }
            catch (ConfigurationException e) {
                ImmutableList<Object> sources = configurationProvider.getBindingSource().map(ImmutableList::of).orElse(ImmutableList.of());
                for (Message message : e.getErrorMessages()) {
                    messages.add(new Message(sources, message.getMessage(), message.getCause()));
                }
            }
        }
        return messages;
    }

    Iterable<ConfigurationProvider<?>> getConfigurationProviders() {
        return ImmutableList.copyOf(this.registeredProviders);
    }

    <T> void registerConfigDefaults(ConfigDefaultsHolder<T> holder) {
        this.registeredDefaultConfigs.put(holder.getConfigKey(), holder);
    }

    private <T> ConfigDefaults<T> getConfigDefaults(Key<T> key) {
        ImmutableList.Builder defaults = ImmutableList.builder();
        Key<T> globalDefaults = Key.get(key.getTypeLiteral(), GlobalDefaults.class);
        this.registeredDefaultConfigs.get((Object)globalDefaults).stream().map(ConfigurationFactory.castHolder()).sorted().map(ConfigDefaultsHolder::getConfigDefaults).forEach(defaults::add);
        this.registeredDefaultConfigs.get((Object)key).stream().map(ConfigurationFactory.castHolder()).sorted().map(ConfigDefaultsHolder::getConfigDefaults).forEach(defaults::add);
        return ConfigDefaults.configDefaults(defaults.build());
    }

    private static <T> Function<ConfigDefaultsHolder<?>, ConfigDefaultsHolder<T>> castHolder() {
        return holder -> holder;
    }

    <T> T getDefaultConfig(Key<T> key) {
        ConfigurationMetadata<T> configurationMetadata = this.getMetadata(key);
        configurationMetadata.getProblems().throwIfHasErrors();
        T instance = ConfigurationFactory.newInstance(configurationMetadata);
        ConfigDefaults<T> configDefaults = this.getConfigDefaults(key);
        configDefaults.setDefaults(instance);
        return instance;
    }

    public <T> T build(Class<T> configClass) {
        return this.build(configClass, null);
    }

    public <T> T build(Class<T> configClass, @Nullable String prefix) {
        return this.build(configClass, Optional.ofNullable(prefix), ConfigDefaults.noDefaults()).getInstance();
    }

    <T> T build(ConfigurationProvider<T> configurationProvider) {
        T existingValue;
        Objects.requireNonNull(configurationProvider, "configurationProvider");
        this.registerConfigurationProvider(configurationProvider, Optional.empty());
        T instance = this.getCachedInstance(configurationProvider);
        if (instance != null) {
            return instance;
        }
        ConfigurationBinding<T> configurationBinding = configurationProvider.getConfigurationBinding();
        ConfigurationHolder<T> holder = this.build(configurationBinding.getConfigClass(), configurationBinding.getPrefix(), this.getConfigDefaults(configurationBinding.getKey()));
        instance = holder.getInstance();
        if (this.warningsMonitor != null) {
            for (Message message : holder.getProblems().getWarnings()) {
                this.warningsMonitor.onWarning(message.toString());
            }
        }
        if ((existingValue = this.putCachedInstance(configurationProvider, instance)) != null) {
            return existingValue;
        }
        return instance;
    }

    private <T> T getCachedInstance(ConfigurationProvider<T> configurationProvider) {
        return (T)this.instanceCache.get(configurationProvider);
    }

    private <T> T putCachedInstance(ConfigurationProvider<T> configurationProvider, T instance) {
        return (T)this.instanceCache.putIfAbsent(configurationProvider, instance);
    }

    private <T> ConfigurationHolder<T> build(Class<T> configClass, Optional<String> configPrefix, ConfigDefaults<T> configDefaults) {
        if (configClass == null) {
            throw new NullPointerException("configClass is null");
        }
        String prefix = configPrefix.map(value -> value + ".").orElse("");
        ConfigurationMetadata<T> configurationMetadata = this.getMetadata(configClass);
        configurationMetadata.getProblems().throwIfHasErrors();
        T instance = ConfigurationFactory.newInstance(configurationMetadata);
        configDefaults.setDefaults(instance);
        Problems problems = new Problems(this.monitor);
        for (ConfigurationMetadata.AttributeMetadata attributeMetadata : configurationMetadata.getAttributes().values()) {
            Problems attributeProblems = new Problems(this.monitor);
            try {
                this.setConfigProperty(instance, attributeMetadata, prefix, attributeProblems);
            }
            catch (InvalidConfigurationException e) {
                attributeProblems.addError(e.getCause(), e.getMessage(), new Object[0]);
            }
            problems.record(attributeProblems);
        }
        if (configClass.isAnnotationPresent(DefunctConfig.class)) {
            for (String value2 : configClass.getAnnotation(DefunctConfig.class).value()) {
                String name = prefix + (String)value2;
                if (value2.isEmpty() || this.properties.get(name) == null) continue;
                problems.addError("Defunct property '%s' (class [%s]) cannot be configured.", name, configClass.toString());
            }
        }
        problems.throwIfHasErrors();
        for (ConstraintViolation constraintViolation : ConfigurationFactory.validate(instance)) {
            String propertyFieldName = constraintViolation.getPropertyPath().toString();
            String attributeName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyFieldName);
            ConfigurationMetadata.AttributeMetadata attribute = configurationMetadata.getAttributes().get(attributeName);
            if (attribute != null && attribute.getInjectionPoint() != null) {
                String propertyName = attribute.getInjectionPoint().getProperty();
                if (!prefix.isEmpty()) {
                    propertyName = prefix + propertyName;
                }
                problems.addError("Invalid configuration property %s: %s (for class %s.%s)", propertyName, constraintViolation.getMessage(), configClass.getName(), constraintViolation.getPropertyPath());
                continue;
            }
            problems.addError("Invalid configuration property with prefix '%s': %s (for class %s.%s)", prefix, constraintViolation.getMessage(), configClass.getName(), constraintViolation.getPropertyPath());
        }
        problems.throwIfHasErrors();
        return new ConfigurationHolder(instance, problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Set<ConstraintViolation<T>> validate(T instance) {
        Validator validator = VALIDATOR;
        synchronized (validator) {
            return VALIDATOR.validate(instance, new Class[0]);
        }
    }

    private <T> ConfigurationMetadata<T> getMetadata(Key<T> key) {
        return this.getMetadata(key.getTypeLiteral().getRawType());
    }

    private <T> ConfigurationMetadata<T> getMetadata(Class<T> configClass) {
        return this.metadataCache.getUnchecked(configClass);
    }

    private static <T> T newInstance(ConfigurationMetadata<T> configurationMetadata) {
        try {
            return configurationMetadata.getConstructor().newInstance(new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw Problems.exceptionFor(e, "Error creating instance of configuration class [%s]", configurationMetadata.getConfigClass().getName());
        }
    }

    private <T> void setConfigProperty(T instance, ConfigurationMetadata.AttributeMetadata attribute, String prefix, Problems problems) throws InvalidConfigurationException {
        ConfigurationMetadata.InjectionPointMetaData injectionPoint = this.findOperativeInjectionPoint(attribute, prefix, problems);
        if (injectionPoint == null) {
            return;
        }
        if (injectionPoint.getSetter().isAnnotationPresent(Deprecated.class)) {
            problems.addWarning("Configuration property '%s' is deprecated and should not be used", prefix + injectionPoint.getProperty());
        }
        Object value = this.getInjectedValue(attribute, injectionPoint, prefix);
        try {
            injectionPoint.getSetter().invoke(instance, value);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw new InvalidConfigurationException(e, String.format("Error invoking configuration method [%s]", injectionPoint.getSetter().toGenericString()));
        }
    }

    private ConfigurationMetadata.InjectionPointMetaData findOperativeInjectionPoint(ConfigurationMetadata.AttributeMetadata attribute, String prefix, Problems problems) throws ConfigurationException {
        ConfigurationMetadata.InjectionPointMetaData operativeInjectionPoint = attribute.getInjectionPoint();
        String operativeName = null;
        String operativeValue = null;
        if (operativeInjectionPoint != null) {
            operativeName = prefix + operativeInjectionPoint.getProperty();
            operativeValue = this.properties.get(operativeName);
        }
        String printableOperativeValue = operativeValue;
        if (attribute.isSecuritySensitive()) {
            printableOperativeValue = "[REDACTED]";
        }
        for (ConfigurationMetadata.InjectionPointMetaData injectionPoint : attribute.getLegacyInjectionPoints()) {
            String value;
            String fullName = prefix + injectionPoint.getProperty();
            String printableValue = value = this.properties.get(fullName);
            if (attribute.isSecuritySensitive()) {
                printableValue = "[REDACTED]";
            }
            if (value == null) continue;
            String replacement = "deprecated.";
            if (attribute.getInjectionPoint() != null) {
                replacement = String.format("replaced. Use '%s' instead.", prefix + attribute.getInjectionPoint().getProperty());
            }
            problems.addWarning("Configuration property '%s' has been " + replacement, fullName);
            if (operativeValue == null) {
                operativeInjectionPoint = injectionPoint;
                operativeValue = value;
                printableOperativeValue = printableValue;
                operativeName = fullName;
                continue;
            }
            problems.addError("Configuration property '%s' (=%s) conflicts with property '%s' (=%s)", fullName, printableValue, operativeName, printableOperativeValue);
        }
        problems.throwIfHasErrors();
        if (operativeValue == null) {
            return null;
        }
        return operativeInjectionPoint;
    }

    private Object getInjectedValue(ConfigurationMetadata.AttributeMetadata attribute, ConfigurationMetadata.InjectionPointMetaData injectionPoint, String prefix) throws InvalidConfigurationException {
        String value;
        String name = prefix + injectionPoint.getProperty();
        this.usedProperties.add(name);
        String printableValue = value = this.properties.get(name);
        if (attribute.isSecuritySensitive()) {
            printableValue = "[REDACTED]";
        }
        if (value == null) {
            return null;
        }
        Class<?> propertyType = injectionPoint.getSetter().getParameterTypes()[0];
        Object finalValue = ConfigurationFactory.coerce(propertyType, value);
        if (finalValue == null) {
            throw new InvalidConfigurationException(String.format("Invalid value '%s' for type %s (property '%s') in order to call [%s]", printableValue, propertyType.getName(), name, injectionPoint.getSetter().toGenericString()));
        }
        return finalValue;
    }

    private static Object coerce(Class<?> type, String value) {
        if (type.isPrimitive() && value == null) {
            return null;
        }
        try {
            if (String.class == type) {
                return value;
            }
            if (Boolean.class == type || Boolean.TYPE == type) {
                if ("true".equalsIgnoreCase(value)) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(value)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            if (Byte.class == type || Byte.TYPE == type) {
                return Byte.valueOf(value);
            }
            if (Short.class == type || Short.TYPE == type) {
                return Short.valueOf(value);
            }
            if (Integer.class == type || Integer.TYPE == type) {
                return Integer.valueOf(value);
            }
            if (Long.class == type || Long.TYPE == type) {
                return Long.valueOf(value);
            }
            if (Float.class == type || Float.TYPE == type) {
                return Float.valueOf(value);
            }
            if (Double.class == type || Double.TYPE == type) {
                return Double.valueOf(value);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        try {
            Method fromString = type.getMethod("fromString", String.class);
            if (fromString.getReturnType().isAssignableFrom(type)) {
                try {
                    return fromString.invoke(null, value);
                }
                catch (ReflectiveOperationException e) {
                    return null;
                }
            }
        }
        catch (NoSuchMethodException fromString) {
            // empty catch block
        }
        if (type.isEnum()) {
            try {
                return Enum.valueOf(type.asSubclass(Enum.class), value);
            }
            catch (IllegalArgumentException fromString) {
                Enum match = null;
                for (Enum option : type.asSubclass(Enum.class).getEnumConstants()) {
                    if (!option.name().equalsIgnoreCase(value)) continue;
                    if (match != null) {
                        return null;
                    }
                    match = option;
                }
                return match;
            }
        }
        try {
            Method valueOf = type.getMethod("valueOf", String.class);
            if (valueOf.getReturnType().isAssignableFrom(type)) {
                try {
                    return valueOf.invoke(null, value);
                }
                catch (ReflectiveOperationException e) {
                    return null;
                }
            }
        }
        catch (NoSuchMethodException valueOf) {
            // empty catch block
        }
        try {
            Constructor<?> constructor = type.getConstructor(String.class);
            try {
                return constructor.newInstance(value);
            }
            catch (ReflectiveOperationException e) {
                return null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    static {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private class ConfigurationProviderConsumer
    implements Consumer<ConfigurationProvider<?>> {
        private final ConfigurationBindingListener listener;
        private final ConfigBinder configBinder;

        public ConfigurationProviderConsumer(ConfigurationBindingListener listener) {
            this.listener = listener;
            this.configBinder = ConfigBinder.configBinder(ConfigurationFactory.this, Optional.of(listener));
        }

        @Override
        public void accept(ConfigurationProvider<?> configurationProvider) {
            this.listener.configurationBound(configurationProvider.getConfigurationBinding(), this.configBinder);
        }
    }

    private static class ConfigurationHolder<T> {
        private final T instance;
        private final Problems problems;

        private ConfigurationHolder(T instance, Problems problems) {
            this.instance = instance;
            this.problems = problems;
        }

        public T getInstance() {
            return this.instance;
        }

        public Problems getProblems() {
            return this.problems;
        }
    }
}

