/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.valueextraction;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.beans.value.ObservableValue;
import javax.validation.valueextraction.UnwrapByDefault;
import javax.validation.valueextraction.ValueExtractor;
import org.apache.bval.util.reflection.Reflection;

public abstract class FxExtractor {

    public static class ForMapPropertyValue
    implements ValueExtractor<ReadOnlyMapProperty<?, ?>> {
        @Override
        public void extractValues(ReadOnlyMapProperty<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            Optional.ofNullable(originalValue.getValue()).ifPresent(m3 -> m3.entrySet().forEach(e -> receiver.keyedValue("<map value>", e.getKey(), e.getValue())));
        }
    }

    public static class ForMapPropertyKey
    implements ValueExtractor<ReadOnlyMapProperty<?, ?>> {
        @Override
        public void extractValues(ReadOnlyMapProperty<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
            Optional.ofNullable(originalValue.getValue()).ifPresent(m3 -> m3.keySet().forEach(k -> receiver.keyedValue("<map key>", k, k)));
        }
    }

    public static class ForSetProperty
    implements ValueExtractor<ReadOnlySetProperty<?>> {
        @Override
        public void extractValues(ReadOnlySetProperty<?> originalValue, ValueExtractor.ValueReceiver receiver) {
            Optional.ofNullable(originalValue.getValue()).ifPresent(s2 -> s2.forEach(e -> receiver.iterableValue("<iterable element>", e)));
        }
    }

    public static class ForListProperty
    implements ValueExtractor<ReadOnlyListProperty<?>> {
        @Override
        public void extractValues(ReadOnlyListProperty<?> originalValue, ValueExtractor.ValueReceiver receiver) {
            Optional.ofNullable(originalValue.getValue()).ifPresent(l -> {
                int sz = l.size();
                for (int i = 0; i < sz; ++i) {
                    receiver.indexedValue("<list element>", i, l.get(i));
                }
            });
        }
    }

    @UnwrapByDefault
    public static class ForObservableValue
    implements ValueExtractor<ObservableValue<?>> {
        @Override
        public void extractValues(ObservableValue<?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value(null, originalValue.getValue());
        }
    }

    public static class Activation
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            try {
                return Reflection.toClass("javafx.beans.Observable") != null;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
}

