/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.validation.MessageInterpolator;
import org.apache.bval.el.MessageEvaluator;
import org.apache.bval.jsr.ApacheMessageContext;
import org.apache.bval.jsr.DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.jsr.DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.util.LookBehindRegexHolder;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class DefaultMessageInterpolator
implements MessageInterpolator {
    private static final Logger log;
    private static final boolean LOG_FINEST;
    private static final String DEFAULT_VALIDATION_MESSAGES = "org.apache.bval.jsr.ValidationMessages";
    private static final String USER_VALIDATION_MESSAGES = "ValidationMessages";
    private static final LookBehindRegexHolder MESSAGE_PARAMETER;
    private Locale defaultLocale;
    private final Map<Locale, ResourceBundle> userBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final Map<Locale, ResourceBundle> defaultBundlesMap = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final MessageEvaluator evaluator;

    public DefaultMessageInterpolator() {
        this(null);
    }

    public DefaultMessageInterpolator(ResourceBundle resourceBundle) {
        MessageEvaluator ev;
        this.defaultLocale = Locale.getDefault();
        this.findDefaultResourceBundle(this.defaultLocale);
        if (resourceBundle == null) {
            this.findUserResourceBundle(this.defaultLocale);
        } else {
            this.userBundlesMap.put(this.defaultLocale, resourceBundle);
        }
        try {
            ev = (MessageEvaluator)MessageEvaluator.class.cast(this.getClass().getClassLoader().loadClass("org.apache.bval.el.ELFacade").getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable e) {
            ev = null;
        }
        this.evaluator = ev;
    }

    @Override
    public String interpolate(String message, MessageInterpolator.Context context) {
        return this.interpolate(message, context, this.defaultLocale);
    }

    @Override
    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        ResourceBundle userResourceBundle = this.findUserResourceBundle(locale);
        ResourceBundle defaultResourceBundle = this.findDefaultResourceBundle(locale);
        Map<String, Object> annotationParameters = context.getConstraintDescriptor().getAttributes();
        String resolvedMessage = message;
        boolean evaluatedDefaultBundleOnce = false;
        while (true) {
            String userBundleResolvedMessage = this.replaceVariables(resolvedMessage, userResourceBundle, locale, true);
            if (evaluatedDefaultBundleOnce && !this.hasReplacementTakenPlace(userBundleResolvedMessage, resolvedMessage)) break;
            resolvedMessage = this.replaceVariables(userBundleResolvedMessage, defaultResourceBundle, locale, false);
            evaluatedDefaultBundleOnce = true;
        }
        resolvedMessage = this.replaceAnnotationAttributes(resolvedMessage, annotationParameters);
        if (this.evaluateExpressionLanguage(message, context)) {
            resolvedMessage = this.evaluator.interpolate(resolvedMessage, annotationParameters, context.getValidatedValue());
        }
        return this.resolveEscapeSequences(resolvedMessage);
    }

    private boolean evaluateExpressionLanguage(String template, MessageInterpolator.Context context) {
        if (this.evaluator != null) {
            if (Objects.equals(template, context.getConstraintDescriptor().getMessageTemplate())) {
                return true;
            }
            Optional<ApacheMessageContext> apacheMessageContext = Optional.of(context).map(ctx -> {
                try {
                    return ctx.unwrap(ApacheMessageContext.class);
                }
                catch (Exception e) {
                    return null;
                }
            });
            return !apacheMessageContext.isPresent() || apacheMessageContext.map(amc -> amc.getConfigurationProperty("apache.bval.custom-template-expression-evaluation")).filter(Boolean::parseBoolean).isPresent();
        }
        return false;
    }

    private String resolveEscapeSequences(String s2) {
        int pos = s2.indexOf(92);
        if (pos < 0) {
            return s2;
        }
        StringBuilder result = new StringBuilder(s2.length());
        int prev = 0;
        while (pos + 1 < s2.length()) {
            if ("\\{}$".indexOf(s2.charAt(pos + 1)) >= 0) {
                result.append(s2, prev, pos);
                prev = pos + 1;
            }
            if ((pos = s2.indexOf(92, pos + 2)) > 0) continue;
        }
        if (prev < s2.length()) {
            result.append(s2, prev, s2.length());
        }
        return result.toString();
    }

    private boolean hasReplacementTakenPlace(String origMessage, String newMessage) {
        return !origMessage.equals(newMessage);
    }

    private ResourceBundle getFileBasedResourceBundle(Locale locale) {
        ClassLoader classLoader = DefaultMessageInterpolator.org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(DefaultMessageInterpolator.class);
        ResourceBundle rb = this.loadBundle(classLoader, locale, USER_VALIDATION_MESSAGES);
        if (LOG_FINEST) {
            if (rb == null) {
                log.log(Level.FINEST, String.format("%s not found. Delegating to %s", USER_VALIDATION_MESSAGES, DEFAULT_VALIDATION_MESSAGES));
            } else {
                log.log(Level.FINEST, String.format("%s found", USER_VALIDATION_MESSAGES));
            }
        }
        return rb;
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$0(Class clazz) {
        return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(Class<?> clazz) {
        return Optional.of(Thread.currentThread()).map(Thread::getContextClassLoader).orElseGet(() -> Validate.notNull(clazz).getClassLoader());
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        try {
            return ResourceBundle.getBundle(USER_VALIDATION_MESSAGES, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.fine(message);
            return null;
        }
    }

    private String replaceVariables(String message, ResourceBundle bundle, Locale locale, boolean recurse) {
        Matcher matcher = MESSAGE_PARAMETER.matcher(message);
        StringBuilder sb = new StringBuilder(64);
        int prev = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (start > prev) {
                sb.append(message, prev, start);
            }
            sb.append(this.resolveParameter(matcher.group(1), bundle, locale, recurse).orElseGet(matcher::group));
            prev = matcher.end();
        }
        if (prev < message.length()) {
            sb.append(message, prev, message.length());
        }
        return sb.toString();
    }

    private String replaceAnnotationAttributes(String message, Map<String, Object> annotationParameters) {
        Matcher matcher = MESSAGE_PARAMETER.matcher(message);
        StringBuilder sb = new StringBuilder(64);
        int prev = 0;
        while (matcher.find()) {
            String resolvedParameterValue;
            int start = matcher.start();
            String parameter = matcher.group(1);
            Object variable = annotationParameters.get(parameter);
            if (variable == null) {
                resolvedParameterValue = matcher.group();
            } else if (Object[].class.isInstance(variable)) {
                resolvedParameterValue = Arrays.toString((Object[])variable);
            } else if (variable.getClass().isArray()) {
                try {
                    resolvedParameterValue = (String)DefaultMessageInterpolator.org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Arrays.class, "toString", new Class[]{variable.getClass()}).invoke(null, variable);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new IllegalStateException("Could not expand array " + variable);
                }
            } else {
                resolvedParameterValue = variable.toString();
            }
            if (start > prev) {
                sb.append(message, prev, start);
            }
            sb.append(resolvedParameterValue);
            prev = matcher.end();
        }
        if (prev < message.length()) {
            sb.append(message, prev, message.length());
        }
        return sb.toString();
    }

    @Privileged
    private static /* synthetic */ Method org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
        }
        return (Method)AccessController.doPrivileged(new DefaultMessageInterpolator$org_apache_bval_util_reflection_Reflection$$getDeclaredMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION(clazz, string, classArray));
    }

    static /* synthetic */ Method __privileged_access$1(Class clazz, String string, Class[] classArray) {
        return DefaultMessageInterpolator.__privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(clazz, string, classArray);
    }

    private static /* synthetic */ Method __privileged_org_apache_bval_util_reflection_Reflection$$getDeclaredMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Optional<String> resolveParameter(String parameterName, ResourceBundle bundle, Locale locale, boolean recurse) {
        return Optional.ofNullable(bundle).map(b -> {
            try {
                return b.getString(parameterName);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }).map(v -> recurse ? this.replaceVariables((String)v, bundle, locale, recurse) : v);
    }

    private ResourceBundle findDefaultResourceBundle(Locale locale) {
        return this.defaultBundlesMap.computeIfAbsent(locale, k -> ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, locale));
    }

    private ResourceBundle findUserResourceBundle(Locale locale) {
        return this.userBundlesMap.computeIfAbsent(locale, this::getFileBasedResourceBundle);
    }

    public void setLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    private static void __privileged_clinit0() {
        log = Logger.getLogger(DefaultMessageInterpolator.class.getName());
        LOG_FINEST = log.isLoggable(Level.FINEST);
        MESSAGE_PARAMETER = new LookBehindRegexHolder("(?<!(?:^|[^\\\\])(?:\\\\\\\\){0,%1$d}\\\\)\\{((?:[\\w\\.]|\\\\[\\{\\$\\}\\\\])+)\\}", n -> (n - 4) / 2);
    }

    static {
        DefaultMessageInterpolator.__privileged_clinit0();
    }
}

