/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.PathElement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class PathSpecification
extends Node {
    private List<PathElement> path;

    public PathSpecification(NodeLocation location, List<PathElement> path) {
        this(Optional.of(location), path);
    }

    @VisibleForTesting
    public PathSpecification(Optional<NodeLocation> location, List<PathElement> path) {
        super(location);
        this.path = ImmutableList.copyOf((Collection)Objects.requireNonNull(path, "path is null"));
    }

    public List<PathElement> getPath() {
        return this.path;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPathSpecification(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.path;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PathSpecification o = (PathSpecification)obj;
        return Objects.equals(this.path, o.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.path);
    }

    @Override
    public String toString() {
        return Joiner.on(", ").join(this.path);
    }
}

