/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Execute
extends Statement {
    private final Identifier name;
    private final List<Expression> parameters;

    public Execute(NodeLocation location, Identifier name, List<Expression> parameters) {
        this(Optional.of(location), name, parameters);
    }

    public Execute(Identifier name, List<Expression> parameters) {
        this(Optional.empty(), name, parameters);
    }

    private Execute(Optional<NodeLocation> location, Identifier name, List<Expression> parameters) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.parameters = Objects.requireNonNull(ImmutableList.copyOf(parameters), "parameters is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExecute(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.parameters;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.parameters);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Execute o = (Execute)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.parameters, o.parameters);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("parameters", this.parameters).toString();
    }
}

