/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import io.airlift.log.Level;
import io.airlift.log.Logging;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public class LoggingMBean {
    private final Logging logging;

    @Inject
    public LoggingMBean(Logging logging) {
        this.logging = logging;
    }

    @Managed
    public String getLevel(String loggerName) {
        return this.logging.getLevel(loggerName).toString();
    }

    @Managed
    public void setLevel(String loggerName, String newLevel) {
        this.logging.setLevel(loggerName, Level.valueOf(newLevel.toUpperCase(Locale.US)));
    }

    @Managed
    public String getRootLevel() {
        return this.logging.getRootLevel().toString();
    }

    @Managed
    public void setRootLevel(String newLevel) {
        this.logging.setRootLevel(Level.valueOf(newLevel.toUpperCase(Locale.US)));
    }

    @Managed
    public Map<String, String> getAllLevels() {
        return ImmutableSortedMap.copyOf(Maps.transformValues(this.logging.getAllLevels(), Object::toString));
    }
}

