/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.openapi.parser;

import com.reprezen.jsonoverlay.IJsonOverlay;
import com.reprezen.jsonoverlay.Overlay;
import com.reprezen.kaizen.oasparser.OpenApi3Parser;
import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.model3.Operation;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.RequestBody;
import com.reprezen.kaizen.oasparser.model3.Response;
import com.reprezen.kaizen.oasparser.model3.Schema;
import io.openvalidation.common.utils.JsonUtils;
import io.openvalidation.openapi.model.OApiRule;
import io.openvalidation.openapi.model.OApiRuleContainer;
import io.openvalidation.openapi.parser.OApiSpecParserKaizen;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class OApiSpecParserKaizen {
    private OpenApi3 _model;

    public OApiSpecParserKaizen parse(String conent) throws Exception {
        OpenApi3Parser parser = new OpenApi3Parser();
        URL url = new URL("file:/C:");
        this._model = parser.parse(conent, url);
        return this;
    }

    public OApiSpecParserKaizen parseFromLocalResource(String resourcName) throws Exception {
        URL url = this.getClass().getClassLoader().getResource(resourcName);
        return this.parseFromURL(url);
    }

    public OApiSpecParserKaizen parseFromURLString(String url) throws Exception {
        return this.parseFromURL(new URL(url));
    }

    public OApiSpecParserKaizen parseFromURL(URL url) throws Exception {
        OpenApi3Parser parser = new OpenApi3Parser();
        this._model = parser.parse(url);
        return this;
    }

    public Schema getSchemaOfRequest(String path, String method) {
        Map paths = this._model.getPaths();
        return ((Operation)((Path)paths.get(path)).getOperations().get(method)).getRequestBody().getContentMediaType("application/json").getSchema();
    }

    public Schema getSchemaOfResponse(String path, String method, String response) {
        Map paths = this._model.getPaths();
        return ((Operation)((Path)paths.get(path)).getOperations().get(method)).getResponse(response).getContentMediaType("application/json").getSchema();
    }

    public JSONObject resolveSchema(Schema schema) {
        JSONObject resolved;
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)schema.getType());
        if (schema.hasProperties()) {
            resolved = this.resolveSchemaArray(schema.getProperties().values().stream().collect(Collectors.toList()));
            JsonUtils.combineProperties((JSONObject)obj, (JSONObject)resolved);
        }
        if (schema.hasAllOfSchemas()) {
            resolved = this.resolveSchemaArray(schema.getAllOfSchemas());
            JsonUtils.combineProperties((JSONObject)obj, (JSONObject)resolved);
        }
        if (schema.hasOneOfSchemas()) {
            resolved = this.resolveSchemaArray(schema.getOneOfSchemas());
            JsonUtils.combineProperties((JSONObject)obj, (JSONObject)resolved);
        }
        if (schema.hasAnyOfSchemas()) {
            resolved = this.resolveSchemaArray(schema.getAnyOfSchemas());
            JsonUtils.combineProperties((JSONObject)obj, (JSONObject)resolved);
        }
        if (schema.hasEnums()) {
            obj.put("enum", (Collection)schema.getEnums());
        }
        return obj;
    }

    public JSONObject resolveSchemaArray(List<Schema> schemas) {
        JSONObject out = new JSONObject();
        out.put("properties", (Object)new JSONObject());
        for (Schema sma : schemas) {
            JSONObject json;
            String type = sma.getType() != null ? sma.getType().toLowerCase() : null;
            String name = sma.getName();
            List enums = sma.getEnums();
            if (type != null && !type.equals("object") && !type.equals("array")) {
                json = new JSONObject();
                json.put("type", (Object)type);
                if (enums != null && enums.size() > 0) {
                    json.put("enum", (Collection)enums);
                }
                out.getJSONObject("properties").put(name, (Object)json);
                continue;
            }
            if (type != null && type.equals("array")) {
                json = new JSONObject();
                json.put("type", (Object)type);
                if (sma.getItemsSchema() != null) {
                    json.put("items", (Object)this.resolveSchema(sma.getItemsSchema()));
                }
                out.getJSONObject("properties").put(name, (Object)json);
                continue;
            }
            JSONObject jso = this.resolveSchema(sma);
            if (name == null) {
                JsonUtils.combineProperties((JSONObject)out, (JSONObject)jso);
                continue;
            }
            out.getJSONObject("properties").put(name, (Object)jso);
        }
        return out;
    }

    public List<MediaTypeMeta> findSchemaByTagName(String extension) {
        ArrayList<MediaTypeMeta> containers = new ArrayList<MediaTypeMeta>();
        if (this._model.hasPaths()) {
            for (Path p : this._model.getPaths().values()) {
                if (!p.hasOperations()) continue;
                for (Operation o : p.getOperations().values()) {
                    MediaType appjson;
                    RequestBody body = o.getRequestBody();
                    if (body != null && (appjson = body.getContentMediaType("application/json")) != null && appjson.hasExtension(extension)) {
                        MediaTypeMeta mtm = new MediaTypeMeta(this, null);
                        mtm.media = appjson;
                        mtm.path = p.getPathString();
                        mtm.operationId = o.getOperationId();
                        mtm.method = Overlay.of((IJsonOverlay)o).getPathInParent().toUpperCase();
                        containers.add(mtm);
                    }
                    if (!o.hasResponses()) continue;
                    for (Response res : o.getResponses().values()) {
                        MediaType mt = res.getContentMediaType("application/json");
                        if (mt == null || !mt.hasExtension(extension)) continue;
                        MediaTypeMeta mtm = new MediaTypeMeta(this, null);
                        mtm.media = mt;
                        mtm.path = p.getPathString();
                        containers.add(mtm);
                    }
                }
            }
        }
        return containers;
    }

    public List<OApiRuleContainer> getRuleContainers() throws Exception {
        ArrayList<OApiRuleContainer> out = new ArrayList<OApiRuleContainer>();
        List mediaTypes = this.findSchemaByTagName("x-ov-rules");
        if (mediaTypes != null && mediaTypes.size() > 0) {
            for (MediaTypeMeta mt : mediaTypes) {
                OApiRuleContainer ruleContainer = new OApiRuleContainer();
                ruleContainer.setSchema(this.resolveSchema(mt.media.getSchema()));
                ruleContainer.setModelName("MDL");
                ruleContainer.setPath(mt.path);
                ruleContainer.setMethod(mt.method);
                LinkedHashMap jo = (LinkedHashMap)mt.media.getExtension("x-ov-rules");
                String plainRule = jo.get("rule").toString();
                if (jo.containsKey("culture")) {
                    ruleContainer.getOptions().setLocale(jo.get("culture").toString());
                }
                OApiRule oar = new OApiRule(plainRule);
                ruleContainer.setRule(oar);
                out.add(ruleContainer);
            }
        }
        return out;
    }

    public static boolean isValidSchema(String rawJson) {
        try {
            OpenApi3Parser parser = new OpenApi3Parser();
            URL url = new URL("file:/C:");
            OpenApi3 model = parser.parse(rawJson, url);
            return model != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

