/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.openapi.generator.client;

import io.openvalidation.common.model.Language;
import io.openvalidation.openapi.OApiValidationGenerator;
import io.openvalidation.openapi.generator.client.JavaScriptClient;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.languages.CSharpClientCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpClient
extends CSharpClientCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaScriptClient.class);
    protected OApiValidationGenerator ovCodegen;

    public String getName() {
        return "ov-csharp-client";
    }

    public String getHelp() {
        return "Generates a charp client library including validation rules generation. powered by openVALIDATION.";
    }

    public CSharpClient() {
        this.embeddedTemplateDir = "csharp";
        this.templateDir = "csharp";
    }

    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> api, List<Object> allModels) {
        if (this.ovCodegen == null) {
            String validationPackage = this.packageName + ".validation";
            String validationFolder = this.sourceFolder.replace('\\', '/') + "/" + this.packageName + "/validation";
            this.ovCodegen = new OApiValidationGenerator((DefaultCodegen)this, LOGGER).withSourceFolder(this.sourceFolder).withBasePackage(this.packageName).withValidationPackage(validationPackage).withValidationFolder(validationFolder).withModelPackage(this.packageName + ".Model").withLanguage(Language.CSharp).generateOVFramework();
        }
        super.postProcessOperationsWithModels(api, allModels);
        this.ovCodegen.generateOVRulesImplementation(this.globalOpenAPI, api);
        this.ovCodegen.generateOVFactoryAtFinalIteration();
        return api;
    }
}

