/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.openapi;

import io.openvalidation.common.model.CodeGenerationResult;
import io.openvalidation.common.model.Language;
import io.openvalidation.common.model.OpenValidationResult;
import io.openvalidation.common.utils.LINQ;
import io.openvalidation.openapi.OApi2OVBridge;
import io.openvalidation.openapi.model.OApiRuleContainer;
import io.openvalidation.openapi.utils.OApiCodegenTemplateUtils;
import io.openvalidation.openapi.utils.OApiModelUtils;
import io.openvalidation.openapi.utils.OApiParserUtils;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.openapitools.codegen.DefaultCodegen;
import org.slf4j.Logger;

public class OApiValidationGenerator {
    private Logger LOGGER = null;
    protected String validationPackage;
    protected String validationFolder;
    protected Language language;
    protected List<OApiRuleContainer> operationRules;
    protected List<CodeGenerationResult> ovValidationRuleCodeResults = this.ovValidationRuleCodeResults = new ArrayList();
    private List<OpenValidationResult> _results = new ArrayList();
    protected String basePackage;
    protected String sourceFolder;
    protected String modelPackage;
    protected DefaultCodegen _oapiCodegen;

    public OApiValidationGenerator(DefaultCodegen oapiCodegen, Logger logger) {
        this.language = Language.Java;
        this._oapiCodegen = oapiCodegen;
        this.LOGGER = logger;
    }

    public OApiValidationGenerator generateOVFramework() {
        if (this.validationPackage == null) {
            this.validationPackage = this.basePackage + ".validation";
        }
        if (this.validationFolder == null) {
            this.validationFolder = this.sourceFolder.replace('\\', '/') + "/" + this.validationPackage.replace('.', '/');
        }
        CodeGenerationResult frameworkCode = new OApi2OVBridge().withLanguage(this.language).withPackage(this.validationPackage).withModelPackage(this.modelPackage).generateRulesFramework();
        OApiCodegenTemplateUtils.addOVFrameworkTemplate((DefaultCodegen)this._oapiCodegen, (String)frameworkCode.getCode(), (String)this.validationFolder, (Language)this.language);
        OApiCodegenTemplateUtils.addOVRulesImplementationTemplate((List)this.ovValidationRuleCodeResults, (DefaultCodegen)this._oapiCodegen, (Language)this.language, (String)this.validationFolder);
        return this;
    }

    public void generateOVRulesImplementation(OpenAPI globalApi, Map<String, Object> api) {
        this.LOGGER.info("start generation of validation rules for operation: ''.");
        this.initOperationRules(globalApi);
        List operationInfo = OApiModelUtils.getOperationInfo(api);
        List rulesContainers = OApiModelUtils.mergeOperationRulesWithOperationInfo((List)operationInfo, (List)this.operationRules);
        if (rulesContainers != null && rulesContainers.size() > 0) {
            OApi2OVBridge ovBridge = new OApi2OVBridge();
            OpenValidationResult result = ovBridge.withLanguage(this.language).withPackage(this.validationPackage).withModelPackage(this.modelPackage).generateRulesForOperations(rulesContainers);
            this.ovValidationRuleCodeResults.addAll(result.getImplementationResults());
            this._results.add(result);
        }
    }

    public void generateOVFactoryAtFinalIteration() {
        if (!this.hasUnprocessedRules()) {
            this.generateOVFactory();
            if (LINQ.any((List)this._results, r -> r.hasErrors())) {
                this.LOGGER.error("generation of validation rules failed.");
                throw new RuntimeException("generation of validation rules failed.");
            }
            this.LOGGER.info("generation of validation rules successfull done.");
        }
    }

    public void generateOVFactory() {
        List validatorInfos = OApiModelUtils.convertToRuleValidatorInfo((List)this.operationRules, (String)"OVRules");
        OApi2OVBridge ovWrapper = new OApi2OVBridge();
        CodeGenerationResult result = ovWrapper.withLanguage(this.language).withPackage(this.validationPackage).withModelPackage(this.modelPackage).generateValidatorFactory(validatorInfos);
        OApiCodegenTemplateUtils.addOVFactoryTemplate((DefaultCodegen)this._oapiCodegen, (String)result.getCode(), (String)this.validationFolder, (Language)this.language);
    }

    public void generateOVReadmeFile() {
        this.generateOVReadmeFile("");
    }

    public void generateOVReadmeFile(String content) {
        OApiCodegenTemplateUtils.addOVReadmeTemplate((DefaultCodegen)this._oapiCodegen, (String)content, (String)this.validationFolder);
    }

    public void generateOVSingleFile(OpenAPI globalApi, Map<String, Object> api) {
        this.initOperationRules(globalApi);
        List operationInfo = OApiModelUtils.getOperationInfo(api);
        List rulesContainers = OApiModelUtils.mergeOperationRulesWithOperationInfo((List)operationInfo, (List)this.operationRules);
        if (rulesContainers != null && rulesContainers.size() > 0) {
            OApi2OVBridge ovWrapper = new OApi2OVBridge();
            OpenValidationResult result = ovWrapper.withLanguage(this.language).withPackage(this.validationPackage).withModelPackage(this.modelPackage).generateAndAppendSingleFileOutput(rulesContainers);
            OApiCodegenTemplateUtils.addOVSingleFileTemplate((DefaultCodegen)this._oapiCodegen, (String)result.getAllCodeContent(), (String)this.validationFolder, (Language)this.language);
        }
    }

    public OApiValidationGenerator withBasePackage(String packageName) {
        this.basePackage = packageName;
        return this;
    }

    public OApiValidationGenerator withSourceFolder(String folder) {
        this.sourceFolder = folder;
        return this;
    }

    public OApiValidationGenerator withValidationPackage(String packageName) {
        this.validationPackage = packageName;
        return this;
    }

    public OApiValidationGenerator withValidationFolder(String folder) {
        this.validationFolder = folder;
        return this;
    }

    public OApiValidationGenerator withModelPackage(String packageName) {
        this.modelPackage = packageName;
        return this;
    }

    public OApiValidationGenerator withLanguage(Language language) {
        this.language = language;
        return this;
    }

    public void initOperationRules(OpenAPI globalOpenAPI) {
        if (this.operationRules == null) {
            this.operationRules = OApiParserUtils.getOperationRules((OpenAPI)globalOpenAPI);
        }
    }

    public String getValidationFolder() {
        return this.validationFolder;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean hasUnprocessedRules() {
        if (this.operationRules == null || this.operationRules.size() < 1) {
            return false;
        }
        return this.operationRules.stream().anyMatch(o -> !o.isProcessed());
    }

    public static OApiValidationGenerator createDefault(DefaultCodegen oapiCodegen, Logger logger, Consumer<OApiValidationGenerator> function) {
        OApiValidationGenerator generator = new OApiValidationGenerator(oapiCodegen, logger);
        try {
            function.accept(generator);
            return generator;
        }
        catch (Exception exp) {
            exp.toString();
            throw exp;
        }
    }
}

