/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.context;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.Arrays;
import javax.annotation.Nullable;

final class PersistentHashArrayMappedTrie {
    private PersistentHashArrayMappedTrie() {
    }

    static Object get(@Nullable Node root, ContextKey<?> key) {
        if (root == null) {
            return null;
        }
        return root.get(key, System.identityHashCode(key), 0);
    }

    static Node put(@Nullable Node root, ContextKey<?> key, Object value) {
        if (root == null) {
            return new Leaf(key, value);
        }
        return root.put(key, value, System.identityHashCode(key), 0);
    }

    static interface Node
    extends Context {
        public int size();

        public Object get(ContextKey<?> var1, int var2, int var3);

        @Override
        @Nullable
        default public <V> V get(ContextKey<V> key) {
            return (V)this.get(key, System.identityHashCode(key), 0);
        }

        public Node put(ContextKey<?> var1, Object var2, int var3, int var4);

        @Override
        default public <V> Context with(ContextKey<V> k1, V v1) {
            return this.put(k1, v1, System.identityHashCode(k1), 0);
        }
    }

    static final class RootNode
    implements Node {
        RootNode() {
        }

        @Override
        public Object get(ContextKey<?> key, int hash, int bitsConsumed) {
            return null;
        }

        @Override
        public Node put(ContextKey<?> key, Object value, int hash, int bitsConsumed) {
            return PersistentHashArrayMappedTrie.put(null, key, value);
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class CompressedIndex
    implements Node {
        private static final int BITS = 5;
        private static final int BITS_MASK = 31;
        final int bitmap;
        final Node[] values;
        private final int size;

        private CompressedIndex(int bitmap, Node[] values, int size) {
            this.bitmap = bitmap;
            this.values = values;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Object get(ContextKey<?> key, int hash, int bitsConsumed) {
            int indexBit = CompressedIndex.indexBit(hash, bitsConsumed);
            if ((this.bitmap & indexBit) == 0) {
                return null;
            }
            int compressedIndex = this.compressedIndex(indexBit);
            return this.values[compressedIndex].get(key, hash, bitsConsumed + 5);
        }

        @Override
        public Node put(ContextKey<?> key, Object value, int hash, int bitsConsumed) {
            int indexBit = CompressedIndex.indexBit(hash, bitsConsumed);
            int compressedIndex = this.compressedIndex(indexBit);
            if ((this.bitmap & indexBit) == 0) {
                int newBitmap = this.bitmap | indexBit;
                Node[] newValues = new Node[this.values.length + 1];
                System.arraycopy(this.values, 0, newValues, 0, compressedIndex);
                newValues[compressedIndex] = new Leaf(key, value);
                System.arraycopy(this.values, compressedIndex, newValues, compressedIndex + 1, this.values.length - compressedIndex);
                return new CompressedIndex(newBitmap, newValues, this.size() + 1);
            }
            Node[] newValues = Arrays.copyOf(this.values, this.values.length);
            newValues[compressedIndex] = this.values[compressedIndex].put(key, value, hash, bitsConsumed + 5);
            int newSize = this.size();
            newSize += newValues[compressedIndex].size();
            return new CompressedIndex(this.bitmap, newValues, newSize -= this.values[compressedIndex].size());
        }

        static Node combine(Node node1, int hash1, Node node2, int hash2, int bitsConsumed) {
            int indexBit2;
            assert (hash1 != hash2);
            int indexBit1 = CompressedIndex.indexBit(hash1, bitsConsumed);
            if (indexBit1 == (indexBit2 = CompressedIndex.indexBit(hash2, bitsConsumed))) {
                Node node = CompressedIndex.combine(node1, hash1, node2, hash2, bitsConsumed + 5);
                Node[] values = new Node[]{node};
                return new CompressedIndex(indexBit1, values, node.size());
            }
            if (CompressedIndex.uncompressedIndex(hash1, bitsConsumed) > CompressedIndex.uncompressedIndex(hash2, bitsConsumed)) {
                Node nodeCopy = node1;
                node1 = node2;
                node2 = nodeCopy;
            }
            Node[] values = new Node[]{node1, node2};
            return new CompressedIndex(indexBit1 | indexBit2, values, node1.size() + node2.size());
        }

        public String toString() {
            StringBuilder valuesSb = new StringBuilder();
            valuesSb.append("CompressedIndex(").append(String.format("bitmap=%s ", Integer.toBinaryString(this.bitmap)));
            for (Node value : this.values) {
                valuesSb.append(value).append(" ");
            }
            return valuesSb.append(")").toString();
        }

        private int compressedIndex(int indexBit) {
            return Integer.bitCount(this.bitmap & indexBit - 1);
        }

        private static int uncompressedIndex(int hash, int bitsConsumed) {
            return hash >>> bitsConsumed & 0x1F;
        }

        private static int indexBit(int hash, int bitsConsumed) {
            int uncompressedIndex = CompressedIndex.uncompressedIndex(hash, bitsConsumed);
            return 1 << uncompressedIndex;
        }
    }

    static final class CollisionLeaf
    implements Node {
        private final ContextKey<?>[] keys;
        private final Object[] values;

        CollisionLeaf(ContextKey<?> key1, Object value1, ContextKey<?> key2, Object value2) {
            this((ContextKey[])new Object[]{key1, key2}, new Object[]{value1, value2});
            assert (key1 != key2);
            assert (System.identityHashCode(key1) == System.identityHashCode(key2));
        }

        private CollisionLeaf(ContextKey<?>[] keys, Object[] values) {
            this.keys = keys;
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public Object get(ContextKey<?> key, int hash, int bitsConsumed) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] != key) continue;
                return this.values[i];
            }
            return null;
        }

        @Override
        public Node put(ContextKey<?> key, Object value, int hash, int bitsConsumed) {
            int thisHash = System.identityHashCode(this.keys[0]);
            if (thisHash != hash) {
                return CompressedIndex.combine(new Leaf(key, value), hash, this, thisHash, bitsConsumed);
            }
            int keyIndex = this.indexOfKey(key);
            if (keyIndex != -1) {
                ContextKey<?>[] newKeys = Arrays.copyOf(this.keys, this.keys.length);
                Object[] newValues = Arrays.copyOf(this.values, this.keys.length);
                newKeys[keyIndex] = key;
                newValues[keyIndex] = value;
                return new CollisionLeaf(newKeys, newValues);
            }
            ContextKey<?>[] newKeys = Arrays.copyOf(this.keys, this.keys.length + 1);
            Object[] newValues = Arrays.copyOf(this.values, this.keys.length + 1);
            newKeys[this.keys.length] = key;
            newValues[this.keys.length] = value;
            return new CollisionLeaf(newKeys, newValues);
        }

        private int indexOfKey(ContextKey<?> key) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] != key) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            StringBuilder valuesSb = new StringBuilder();
            valuesSb.append("CollisionLeaf(");
            for (int i = 0; i < this.values.length; ++i) {
                valuesSb.append("(key=").append(this.keys[i]).append(" value=").append(this.values[i]).append(") ");
            }
            return valuesSb.append(")").toString();
        }
    }

    static final class Leaf
    implements Node {
        private final ContextKey<?> key;
        private final Object value;

        public Leaf(ContextKey<?> key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Object get(ContextKey<?> key, int hash, int bitsConsumed) {
            if (this.key == key) {
                return this.value;
            }
            return null;
        }

        @Override
        public Node put(ContextKey<?> key, Object value, int hash, int bitsConsumed) {
            int thisHash = System.identityHashCode(this.key);
            if (thisHash != hash) {
                return CompressedIndex.combine(new Leaf(key, value), hash, this, thisHash, bitsConsumed);
            }
            if (this.key == key) {
                return new Leaf(key, value);
            }
            return new CollisionLeaf(this.key, this.value, key, value);
        }

        public String toString() {
            return String.format("Leaf(key=%s value=%s)", this.key, this.value);
        }
    }
}

