/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Labels;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.Utils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.AsynchronousInstrument;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.BatchRecorder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleSumObserver;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleUpDownSumObserver;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleValueObserver;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleValueRecorder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Instrument;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongSumObserver;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongUpDownSumObserver;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongValueObserver;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongValueRecorder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DefaultMeter
implements Meter {
    private static final DefaultMeter INSTANCE = new DefaultMeter();
    private static final String COUNTERS_CAN_ONLY_INCREASE = "Counters can only increase";
    static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";

    static Meter getInstance() {
        return INSTANCE;
    }

    @Override
    public DoubleCounter.Builder doubleCounterBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleCounter.NoopBuilder();
    }

    @Override
    public LongCounter.Builder longCounterBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongCounter.NoopBuilder();
    }

    @Override
    public DoubleUpDownCounter.Builder doubleUpDownCounterBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleUpDownCounter.NoopBuilder();
    }

    @Override
    public LongUpDownCounter.Builder longUpDownCounterBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongUpDownCounter.NoopBuilder();
    }

    @Override
    public DoubleValueRecorder.Builder doubleValueRecorderBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleValueRecorder.NoopBuilder();
    }

    @Override
    public LongValueRecorder.Builder longValueRecorderBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongValueRecorder.NoopBuilder();
    }

    @Override
    public DoubleSumObserver.Builder doubleSumObserverBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleSumObserver.NoopBuilder();
    }

    @Override
    public LongSumObserver.Builder longSumObserverBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongSumObserver.NoopBuilder();
    }

    @Override
    public DoubleUpDownSumObserver.Builder doubleUpDownSumObserverBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleUpDownSumObserver.NoopBuilder();
    }

    @Override
    public LongUpDownSumObserver.Builder longUpDownSumObserverBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongUpDownSumObserver.NoopBuilder();
    }

    @Override
    public DoubleValueObserver.Builder doubleValueObserverBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopDoubleValueObserver.NoopBuilder();
    }

    @Override
    public LongValueObserver.Builder longValueObserverBuilder(String name) {
        Objects.requireNonNull(name, "name");
        Utils.checkArgument(StringUtils.isValidMetricName(name), ERROR_MESSAGE_INVALID_NAME);
        return new NoopLongValueObserver.NoopBuilder();
    }

    @Override
    public BatchRecorder newBatchRecorder(String ... keyValuePairs) {
        Utils.validateLabelPairs(keyValuePairs);
        return NoopBatchRecorder.INSTANCE;
    }

    private DefaultMeter() {
    }

    private static abstract class NoopAbstractInstrumentBuilder<B extends NoopAbstractInstrumentBuilder<B>>
    implements Instrument.Builder {
        private NoopAbstractInstrumentBuilder() {
        }

        public B setDescription(String description) {
            Objects.requireNonNull(description, "description");
            return this.getThis();
        }

        public B setUnit(String unit) {
            Objects.requireNonNull(unit, "unit");
            return this.getThis();
        }

        protected abstract B getThis();
    }

    private static enum NoopBatchRecorder implements BatchRecorder
    {
        INSTANCE;


        @Override
        public BatchRecorder put(LongValueRecorder valueRecorder, long value) {
            Objects.requireNonNull(valueRecorder, "valueRecorder");
            return this;
        }

        @Override
        public BatchRecorder put(DoubleValueRecorder valueRecorder, double value) {
            Objects.requireNonNull(valueRecorder, "valueRecorder");
            return this;
        }

        @Override
        public BatchRecorder put(LongCounter counter, long value) {
            Objects.requireNonNull(counter, "counter");
            Utils.checkArgument(value >= 0L, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
            return this;
        }

        @Override
        public BatchRecorder put(DoubleCounter counter, double value) {
            Objects.requireNonNull(counter, "counter");
            Utils.checkArgument(value >= 0.0, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
            return this;
        }

        @Override
        public BatchRecorder put(LongUpDownCounter upDownCounter, long value) {
            Objects.requireNonNull(upDownCounter, "upDownCounter");
            return this;
        }

        @Override
        public BatchRecorder put(DoubleUpDownCounter upDownCounter, double value) {
            Objects.requireNonNull(upDownCounter, "upDownCounter");
            return this;
        }

        @Override
        public void record() {
        }
    }

    @Immutable
    private static final class NoopLongValueObserver
    implements LongValueObserver {
        private NoopLongValueObserver() {
        }

        @Override
        @Deprecated
        public void setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.LongResult> callback) {
            Objects.requireNonNull(callback, "callback");
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongValueObserver.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongValueObserver.Builder setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.LongResult> callback) {
                Objects.requireNonNull(callback, "callback");
                return this;
            }

            @Override
            public LongValueObserver build() {
                return new NoopLongValueObserver();
            }
        }
    }

    @Immutable
    private static final class NoopDoubleValueObserver
    implements DoubleValueObserver {
        private NoopDoubleValueObserver() {
        }

        @Override
        @Deprecated
        public void setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.DoubleResult> callback) {
            Objects.requireNonNull(callback, "callback");
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleValueObserver.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleValueObserver.Builder setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.DoubleResult> callback) {
                Objects.requireNonNull(callback, "callback");
                return this;
            }

            @Override
            public DoubleValueObserver build() {
                return new NoopDoubleValueObserver();
            }
        }
    }

    @Immutable
    private static final class NoopLongUpDownSumObserver
    implements LongUpDownSumObserver {
        private NoopLongUpDownSumObserver() {
        }

        @Override
        @Deprecated
        public void setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.LongResult> callback) {
            Objects.requireNonNull(callback, "callback");
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongUpDownSumObserver.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongUpDownSumObserver.Builder setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.LongResult> callback) {
                Objects.requireNonNull(callback, "callback");
                return this;
            }

            @Override
            public LongUpDownSumObserver build() {
                return new NoopLongUpDownSumObserver();
            }
        }
    }

    @Immutable
    private static final class NoopDoubleUpDownSumObserver
    implements DoubleUpDownSumObserver {
        private NoopDoubleUpDownSumObserver() {
        }

        @Override
        @Deprecated
        public void setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.DoubleResult> callback) {
            Objects.requireNonNull(callback, "callback");
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleUpDownSumObserver.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleUpDownSumObserver.Builder setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.DoubleResult> callback) {
                Objects.requireNonNull(callback, "callback");
                return this;
            }

            @Override
            public DoubleUpDownSumObserver build() {
                return new NoopDoubleUpDownSumObserver();
            }
        }
    }

    @Immutable
    private static final class NoopLongSumObserver
    implements LongSumObserver {
        private NoopLongSumObserver() {
        }

        @Override
        @Deprecated
        public void setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.LongResult> callback) {
            Objects.requireNonNull(callback, "callback");
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongSumObserver.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public NoopBuilder setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.LongResult> callback) {
                Objects.requireNonNull(callback, "callback");
                return this;
            }

            @Override
            public LongSumObserver build() {
                return new NoopLongSumObserver();
            }
        }
    }

    @Immutable
    private static final class NoopDoubleSumObserver
    implements DoubleSumObserver {
        private NoopDoubleSumObserver() {
        }

        @Override
        @Deprecated
        public void setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.DoubleResult> callback) {
            Objects.requireNonNull(callback, "callback");
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleSumObserver.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleSumObserver.Builder setCallback(AsynchronousInstrument.Callback<AsynchronousInstrument.DoubleResult> callback) {
                Objects.requireNonNull(callback, "callback");
                return this;
            }

            @Override
            public DoubleSumObserver build() {
                return new NoopDoubleSumObserver();
            }
        }
    }

    @Immutable
    private static final class NoopLongValueRecorder
    implements LongValueRecorder {
        private NoopLongValueRecorder() {
        }

        @Override
        public void record(long value, Labels labels) {
            Objects.requireNonNull(labels, "labels");
        }

        @Override
        public void record(long value) {
            this.record(value, Labels.empty());
        }

        @Override
        public NoopBoundLongValueRecorder bind(Labels labels) {
            Objects.requireNonNull(labels, "labels");
            return NoopBoundLongValueRecorder.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongValueRecorder.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongValueRecorder build() {
                return new NoopLongValueRecorder();
            }
        }

        @Immutable
        private static enum NoopBoundLongValueRecorder implements LongValueRecorder.BoundLongValueRecorder
        {
            INSTANCE;


            @Override
            public void record(long value) {
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopDoubleValueRecorder
    implements DoubleValueRecorder {
        private NoopDoubleValueRecorder() {
        }

        @Override
        public void record(double value, Labels labels) {
            Objects.requireNonNull(labels, "labels");
        }

        @Override
        public void record(double value) {
            this.record(value, Labels.empty());
        }

        @Override
        public NoopBoundDoubleValueRecorder bind(Labels labels) {
            Objects.requireNonNull(labels, "labels");
            return NoopBoundDoubleValueRecorder.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleValueRecorder.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleValueRecorder build() {
                return new NoopDoubleValueRecorder();
            }
        }

        @Immutable
        private static enum NoopBoundDoubleValueRecorder implements DoubleValueRecorder.BoundDoubleValueRecorder
        {
            INSTANCE;


            @Override
            public void record(double value) {
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopLongUpDownCounter
    implements LongUpDownCounter {
        private NoopLongUpDownCounter() {
        }

        @Override
        public void add(long increment, Labels labels) {
            Objects.requireNonNull(labels, "labels");
        }

        @Override
        public void add(long increment) {
            this.add(increment, Labels.empty());
        }

        @Override
        public NoopBoundLongUpDownCounter bind(Labels labels) {
            Objects.requireNonNull(labels, "labels");
            return NoopBoundLongUpDownCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongUpDownCounter.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongUpDownCounter build() {
                return new NoopLongUpDownCounter();
            }
        }

        @Immutable
        private static enum NoopBoundLongUpDownCounter implements LongUpDownCounter.BoundLongUpDownCounter
        {
            INSTANCE;


            @Override
            public void add(long increment) {
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopDoubleUpDownCounter
    implements DoubleUpDownCounter {
        private NoopDoubleUpDownCounter() {
        }

        @Override
        public void add(double increment, Labels labels) {
            Objects.requireNonNull(labels, "labels");
        }

        @Override
        public void add(double increment) {
            this.add(increment, Labels.empty());
        }

        @Override
        public NoopBoundDoubleUpDownCounter bind(Labels labels) {
            Objects.requireNonNull(labels, "labels");
            return NoopBoundDoubleUpDownCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleUpDownCounter.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleUpDownCounter build() {
                return new NoopDoubleUpDownCounter();
            }
        }

        @Immutable
        private static enum NoopBoundDoubleUpDownCounter implements DoubleUpDownCounter.BoundDoubleUpDownCounter
        {
            INSTANCE;


            @Override
            public void add(double increment) {
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopLongCounter
    implements LongCounter {
        private NoopLongCounter() {
        }

        @Override
        public void add(long increment, Labels labels) {
            Objects.requireNonNull(labels, "labels");
            Utils.checkArgument(increment >= 0L, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
        }

        @Override
        public void add(long increment) {
            this.add(increment, Labels.empty());
        }

        @Override
        public NoopBoundLongCounter bind(Labels labels) {
            Objects.requireNonNull(labels, "labels");
            return NoopBoundLongCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements LongCounter.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public LongCounter build() {
                return new NoopLongCounter();
            }
        }

        @Immutable
        private static enum NoopBoundLongCounter implements LongCounter.BoundLongCounter
        {
            INSTANCE;


            @Override
            public void add(long increment) {
                Utils.checkArgument(increment >= 0L, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
            }

            @Override
            public void unbind() {
            }
        }
    }

    @Immutable
    private static final class NoopDoubleCounter
    implements DoubleCounter {
        private NoopDoubleCounter() {
        }

        @Override
        public void add(double increment, Labels labels) {
            Objects.requireNonNull(labels, "labels");
            Utils.checkArgument(increment >= 0.0, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
        }

        @Override
        public void add(double increment) {
            this.add(increment, Labels.empty());
        }

        @Override
        public NoopBoundDoubleCounter bind(Labels labels) {
            Objects.requireNonNull(labels, "labels");
            return NoopBoundDoubleCounter.INSTANCE;
        }

        private static final class NoopBuilder
        extends NoopAbstractInstrumentBuilder<NoopBuilder>
        implements DoubleCounter.Builder {
            private NoopBuilder() {
            }

            @Override
            protected NoopBuilder getThis() {
                return this;
            }

            @Override
            public DoubleCounter build() {
                return new NoopDoubleCounter();
            }
        }

        @Immutable
        private static enum NoopBoundDoubleCounter implements DoubleCounter.BoundDoubleCounter
        {
            INSTANCE;


            @Override
            public void add(double increment) {
                Utils.checkArgument(increment >= 0.0, DefaultMeter.COUNTERS_CAN_ONLY_INCREASE);
            }

            @Override
            public void unbind() {
            }
        }
    }
}

