/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.bootstrap.InstrumentationHolder;
import io.opentelemetry.javaagent.bootstrap.VirtualFieldDetector;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.field.FieldAccessorInterfaces;
import io.opentelemetry.javaagent.tooling.field.FieldAccessorInterfacesGenerator;
import io.opentelemetry.javaagent.tooling.field.RealFieldInjector;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldFindRewriter;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementationInstaller;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementations;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementationsGenerator;
import io.opentelemetry.javaagent.tooling.instrumentation.InstrumentationModuleInstaller;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappings;
import io.opentelemetry.javaagent.tooling.util.IgnoreFailedTypeMatcher;
import io.opentelemetry.javaagent.tooling.util.NamedMatcher;
import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

final class FieldBackedImplementationInstaller
implements VirtualFieldImplementationInstaller {
    private static final TransformSafeLogger logger = TransformSafeLogger.getLogger(FieldBackedImplementationInstaller.class);
    private static final boolean FIELD_INJECTION_ENABLED = Config.get().getBoolean("otel.javaagent.experimental.field-injection.enabled", true);
    private final Class<?> instrumenterClass;
    private final VirtualFieldMappings virtualFieldMappings;
    private final FieldAccessorInterfaces fieldAccessorInterfaces;
    private final AgentBuilder.Transformer fieldAccessorInterfacesInjector;
    private final VirtualFieldImplementations virtualFieldImplementations;
    private final AgentBuilder.Transformer virtualFieldImplementationsInjector;
    private final Instrumentation instrumentation;
    private static final Set<Map.Entry<String, String>> INSTALLED_VIRTUAL_FIELD_MATCHERS = new HashSet<Map.Entry<String, String>>();

    public FieldBackedImplementationInstaller(Class<?> instrumenterClass, VirtualFieldMappings virtualFieldMappings) {
        this.instrumenterClass = instrumenterClass;
        this.virtualFieldMappings = virtualFieldMappings;
        this.instrumentation = InstrumentationHolder.getInstrumentation();
        ByteBuddy byteBuddy = new ByteBuddy();
        this.fieldAccessorInterfaces = new FieldAccessorInterfacesGenerator(byteBuddy).generateFieldAccessorInterfaces(virtualFieldMappings);
        this.fieldAccessorInterfacesInjector = this.bootstrapHelperInjector(this.fieldAccessorInterfaces.getAllInterfaces());
        this.virtualFieldImplementations = new VirtualFieldImplementationsGenerator(byteBuddy).generateClasses(virtualFieldMappings, this.fieldAccessorInterfaces);
        this.virtualFieldImplementationsInjector = this.bootstrapHelperInjector(this.virtualFieldImplementations.getAllClasses());
    }

    @Override
    public AgentBuilder.Identified.Extendable rewriteVirtualFieldsCalls(AgentBuilder.Identified.Extendable builder) {
        if (!this.virtualFieldMappings.isEmpty()) {
            builder = builder.transform(FieldBackedImplementationInstaller.getTransformerForAsmVisitor(new VirtualFieldFindRewriter(this.instrumenterClass, this.virtualFieldMappings, this.virtualFieldImplementations)));
            builder = this.injectHelpersIntoBootstrapClassloader(builder);
        }
        return builder;
    }

    private AgentBuilder.Identified.Extendable injectHelpersIntoBootstrapClassloader(AgentBuilder.Identified.Extendable builder) {
        builder = builder.transform(this.fieldAccessorInterfacesInjector);
        builder = builder.transform(this.virtualFieldImplementationsInjector);
        return builder;
    }

    private AgentBuilder.Transformer bootstrapHelperInjector(final Collection<DynamicType.Unloaded<?>> helpers) {
        return new AgentBuilder.Transformer(){
            final HelperInjector injector;
            {
                this.injector = HelperInjector.forDynamicTypes((String)this.getClass().getSimpleName(), (Collection)helpers, (Instrumentation)FieldBackedImplementationInstaller.this.instrumentation);
            }

            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return this.injector.transform(builder, typeDescription, null, module);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentBuilder.Identified.Extendable injectFields(AgentBuilder.Identified.Extendable builder) {
        if (FIELD_INJECTION_ENABLED) {
            for (Map.Entry entry : this.virtualFieldMappings.entrySet()) {
                Set<Map.Entry<String, String>> set = INSTALLED_VIRTUAL_FIELD_MATCHERS;
                synchronized (set) {
                    if (INSTALLED_VIRTUAL_FIELD_MATCHERS.contains(entry)) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "Skipping builder for {0} {1}", new Object[]{this.instrumenterClass.getName(), entry});
                        }
                        continue;
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Making builder for {0} {1}", new Object[]{this.instrumenterClass.getName(), entry});
                    }
                    INSTALLED_VIRTUAL_FIELD_MATCHERS.add(entry);
                    NamedMatcher<TypeDescription> typeMatcher = new NamedMatcher<TypeDescription>("VirtualField", new IgnoreFailedTypeMatcher((ElementMatcher<TypeDescription>)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()).and((ElementMatcher)AgentElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)((String)entry.getKey()))))));
                    builder = ((AgentBuilder.Identified.Narrowable)((AgentBuilder.Identified.Narrowable)builder.type(typeMatcher).and(FieldBackedImplementationInstaller.safeToInjectFieldsMatcher())).and(InstrumentationModuleInstaller.NOT_DECORATOR_MATCHER)).transform((AgentBuilder.Transformer)NoOpTransformer.INSTANCE);
                    builder = this.injectHelpersIntoBootstrapClassloader(builder);
                    builder = builder.transform(FieldBackedImplementationInstaller.getTransformerForAsmVisitor(new RealFieldInjector(this.fieldAccessorInterfaces, (String)entry.getKey(), (String)entry.getValue())));
                }
            }
        }
        return builder;
    }

    private static AgentBuilder.RawMatcher safeToInjectFieldsMatcher() {
        return (typeDescription, classLoader, module, classBeingRedefined, protectionDomain) -> classBeingRedefined == null || VirtualFieldDetector.hasVirtualFields((Class)classBeingRedefined);
    }

    private static AgentBuilder.Transformer getTransformerForAsmVisitor(AsmVisitorWrapper visitor) {
        return (builder, typeDescription, classLoader, module) -> builder.visit(visitor);
    }

    static enum NoOpTransformer implements AgentBuilder.Transformer
    {
        INSTANCE;


        public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            return builder;
        }
    }
}

