/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.tooling.RemappingUrlStreamHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.bytebuddy.dynamic.loading.MultipleParentClassLoader;

public class ExtensionClassLoader
extends URLClassLoader {
    public static final String EXTENSIONS_CONFIG = "otel.javaagent.extensions";

    public static ClassLoader getInstance(ClassLoader parent, File javaagentFile) {
        ArrayList<URL> extensions = new ArrayList<URL>();
        ExtensionClassLoader.includeEmbeddedExtensionsIfFound(parent, extensions, javaagentFile);
        extensions.addAll(ExtensionClassLoader.parseLocation(System.getProperty(EXTENSIONS_CONFIG, System.getenv("OTEL_JAVAAGENT_EXTENSIONS")), javaagentFile));
        extensions.addAll(ExtensionClassLoader.parseLocation(System.getProperty("otel.javaagent.experimental.extensions", System.getenv("OTEL_JAVAAGENT_EXPERIMENTAL_EXTENSIONS")), javaagentFile));
        extensions.addAll(ExtensionClassLoader.parseLocation(System.getProperty("otel.javaagent.experimental.initializer.jar", System.getenv("OTEL_JAVAAGENT_EXPERIMENTAL_INITIALIZER_JAR")), javaagentFile));
        if (extensions.isEmpty()) {
            return parent;
        }
        ArrayList<URLClassLoader> delegates = new ArrayList<URLClassLoader>(extensions.size());
        for (URL url : extensions) {
            delegates.add(ExtensionClassLoader.getDelegate(parent, url));
        }
        return new MultipleParentClassLoader(parent, delegates);
    }

    private static void includeEmbeddedExtensionsIfFound(ClassLoader parent, List<URL> extensions, File javaagentFile) {
        try {
            JarFile jarFile = new JarFile(javaagentFile, false);
            Enumeration<JarEntry> entryEnumeration = jarFile.entries();
            String prefix = "extensions/";
            File tempDirectory = null;
            while (entryEnumeration.hasMoreElements()) {
                JarEntry jarEntry = entryEnumeration.nextElement();
                if (!jarEntry.getName().startsWith(prefix) || jarEntry.isDirectory()) continue;
                File tempFile = new File(tempDirectory = ExtensionClassLoader.ensureTempDirectoryExists(tempDirectory), jarEntry.getName().substring(prefix.length()));
                if (tempFile.createNewFile()) {
                    tempFile.deleteOnExit();
                    ExtensionClassLoader.extractFile(jarFile, jarEntry, tempFile);
                    ExtensionClassLoader.addFileUrl(extensions, tempFile);
                    continue;
                }
                System.err.println("Failed to create temp file " + tempFile);
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to open embedded extensions " + ex.getMessage());
        }
    }

    private static File ensureTempDirectoryExists(File tempDirectory) throws IOException {
        if (tempDirectory == null) {
            tempDirectory = Files.createTempDirectory("otel-extensions", new FileAttribute[0]).toFile();
            tempDirectory.deleteOnExit();
        }
        return tempDirectory;
    }

    private static URLClassLoader getDelegate(ClassLoader parent, URL extensionUrl) {
        return new ExtensionClassLoader(new URL[]{extensionUrl}, parent);
    }

    private static List<URL> parseLocation(String locationName, File javaagentFile) {
        File[] files;
        ArrayList<URL> result = new ArrayList<URL>();
        if (locationName == null) {
            return result;
        }
        File location = new File(locationName);
        if (location.isFile()) {
            ExtensionClassLoader.addFileUrl(result, location);
        } else if (location.isDirectory() && (files = location.listFiles(f -> f.isFile() && f.getName().endsWith(".jar"))) != null) {
            for (File file : files) {
                if (file.getAbsolutePath().equals(javaagentFile.getAbsolutePath())) continue;
                ExtensionClassLoader.addFileUrl(result, file);
            }
        }
        return result;
    }

    private static void addFileUrl(List<URL> result, File file) {
        try {
            URL wrappedUrl = new URL("otel", null, -1, "/", new RemappingUrlStreamHandler(file));
            result.add(wrappedUrl);
        }
        catch (MalformedURLException ignored) {
            System.err.println("Ignoring " + file);
        }
    }

    private static void extractFile(JarFile jarFile, JarEntry jarEntry, File outputFile) throws IOException {
        try (InputStream in = jarFile.getInputStream(jarEntry);
             ReadableByteChannel rbc = Channels.newChannel(in);
             FileOutputStream fos = new FileOutputStream(outputFile);){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }

    private ExtensionClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

