/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.internal;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.instrumentation.api.util.Trie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstrumentedTaskClasses {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static final String AGENT_CLASSLOADER_NAME = "io.opentelemetry.javaagent.bootstrap.AgentClassLoader";
    private static final ClassValue<Boolean> INSTRUMENTED_TASK_CLASS = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(Class<?> taskClass) {
            if (ignoredTaskClasses.getOrDefault(taskClass.getName(), false).booleanValue()) {
                return false;
            }
            ClassLoader taskClassLoader = taskClass.getClassLoader();
            if (taskClassLoader != null && InstrumentedTaskClasses.AGENT_CLASSLOADER_NAME.equals(taskClassLoader.getClass().getName())) {
                return false;
            }
            return true;
        }
    };
    private static volatile Trie<Boolean> ignoredTaskClasses;

    public static void setIgnoredTaskClasses(Trie<Boolean> ignoredTasksTrie) {
        if (ignoredTaskClasses != null) {
            logger.warn("Ignored task classes were already set earlier; returning.");
            return;
        }
        ignoredTaskClasses = ignoredTasksTrie;
    }

    public static boolean canInstrumentTaskClass(Class<?> taskClass) {
        return INSTRUMENTED_TASK_CLASS.get(taskClass);
    }

    private InstrumentedTaskClasses() {
    }
}

