/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.concurrent;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.ContextPropagationDebug;
import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.instrumentation.api.concurrent.State;
import io.opentelemetry.javaagent.instrumentation.api.internal.InstrumentedTaskClasses;

public final class ExecutorInstrumentationUtils {
    public static boolean shouldAttachStateToTask(Object task) {
        if (task == null) {
            return false;
        }
        if (Context.current() == Context.root()) {
            return false;
        }
        return InstrumentedTaskClasses.canInstrumentTaskClass(task.getClass());
    }

    public static <T> State setupState(ContextStore<T, State> contextStore, T task, Context context) {
        State state = contextStore.putIfAbsent(task, State.FACTORY);
        if (ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            context = ContextPropagationDebug.appendLocations((Context)context, (StackTraceElement[])new Exception().getStackTrace(), task);
        }
        state.setParentContext(context);
        return state;
    }

    public static void cleanUpOnMethodExit(State state, Throwable throwable) {
        if (null != state && null != throwable) {
            state.clearParentContext();
        }
    }

    private ExecutorInstrumentationUtils() {
    }
}

